/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.ns.NamespaceResolver;
import de.betterform.xml.xforms.Container;
import de.betterform.xml.xforms.XFormsConstants;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.bind.Binding;
import de.betterform.xml.xforms.model.bind.BindingResolver;
import de.betterform.xml.xforms.ui.BindingElement;
import de.betterform.xml.xforms.ui.Group;
import de.betterform.xml.xforms.ui.Item;
import de.betterform.xml.xforms.ui.Repeat;
import de.betterform.xml.xforms.ui.RepeatItem;
import de.betterform.xml.xforms.ui.Switch;
import de.betterform.xml.xforms.xpath.saxon.function.XPathFunctionContext;
import de.betterform.xml.xpath.XPathUtil;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public abstract class XFormsElement
implements XFormsConstants {
    protected Container container = null;
    protected Element element = null;
    protected EventTarget target = null;
    protected Model model = null;
    protected String id;
    protected String originalId;
    protected String xformsPrefix = null;
    protected final Map prefixMapping;
    protected final XPathFunctionContext xpathFunctionContext;

    public XFormsElement(Element element) {
        this.element = element;
        this.target = (EventTarget)((Object)element);
        this.container = this.getContainerObject();
        this.xformsPrefix = NamespaceResolver.getPrefix(this.element, "http://www.w3.org/2002/xforms");
        this.prefixMapping = NamespaceResolver.getAllNamespaces(this.element);
        this.xpathFunctionContext = new XPathFunctionContext(this);
        if (this.element.hasAttributeNS(null, "id")) {
            this.id = this.element.getAttributeNS(null, "id");
        } else {
            this.id = this.container.generateId();
            this.element.setAttributeNS(null, "id", this.id);
        }
        this.registerId();
    }

    public XFormsElement(Element element, Model model) {
        this(element);
        this.model = model;
    }

    public abstract void init() throws XFormsException;

    public abstract void dispose() throws XFormsException;

    public Container getContainerObject() {
        return (Container)this.element.getOwnerDocument().getDocumentElement().getUserData("");
    }

    public Element getElement() {
        return this.element;
    }

    public String getId() {
        return this.id;
    }

    public Model getModel() {
        return this.model;
    }

    public XFormsElement getParentObject() {
        return (XFormsElement)this.element.getParentNode().getUserData("");
    }

    public EventTarget getTarget() {
        return this.target;
    }

    public String getXFormsAttribute(String name) {
        return XFormsElement.getXFormsAttribute(this.element, name);
    }

    public static String getXFormsAttribute(Element element, String name) {
        if (element.hasAttributeNS("http://www.w3.org/2002/xforms", name)) {
            return element.getAttributeNS("http://www.w3.org/2002/xforms", name);
        }
        if (element.hasAttributeNS(null, name)) {
            return element.getAttributeNS(null, name);
        }
        return null;
    }

    public String getBFAttribute(String name) {
        return XFormsElement.getBFAttribute(this.element, name);
    }

    public Map<String, String> getCustomMIPAttributes() {
        HashMap<String, String> customMIPAttributes = new HashMap<String, String>();
        NamedNodeMap nnm = this.element.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node attribute = nnm.item(i);
            if (attribute.getNamespaceURI() == null || "http://betterform.sourceforge.net/xforms".equals(attribute.getNamespaceURI()) || "http://www.w3.org/2002/xforms".equals(attribute.getNamespaceURI()) || "http://www.w3.org/1999/xhtml".equals(attribute.getNamespaceURI()) || "http://www.w3.org/2000/xmlns/".equals(attribute.getNamespaceURI()) || "http://www.w3.org/2001/XMLSchema-instance".equals(attribute.getNamespaceURI()) || "http://www.w3.org/2001/xml-events".equals(attribute.getNamespaceURI())) continue;
            customMIPAttributes.put(attribute.getPrefix() + WordUtils.capitalize((String)attribute.getLocalName()), attribute.getTextContent());
        }
        return customMIPAttributes;
    }

    public static String getBFAttribute(Element element, String name) {
        if (element.hasAttributeNS("http://betterform.sourceforge.net/xforms", name)) {
            return element.getAttributeNS("http://betterform.sourceforge.net/xforms", name);
        }
        if (element.hasAttributeNS(null, name)) {
            return element.getAttributeNS(null, name);
        }
        return null;
    }

    public Map getPrefixMapping() {
        return Collections.unmodifiableMap(this.prefixMapping);
    }

    public XPathFunctionContext getXPathFunctionContext() {
        return this.xpathFunctionContext;
    }

    public void registerId() {
        this.container.register(this);
        if (this.originalId != null) {
            String tmpId = this.id;
            this.id = this.originalId;
            this.container.register(this);
            this.id = tmpId;
        }
    }

    public void deregister() {
        this.container.deregister(this);
    }

    public void setGeneratedId(String generatedId) throws XFormsException {
        this.originalId = this.id;
        this.id = generatedId;
        this.element.setAttributeNS(null, "id", this.id);
        if (this.model.isReady()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("originalId", this.originalId);
            this.container.dispatch(this.target, "betterform-id-generated", map);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof XFormsElement)) {
            return false;
        }
        return ((XFormsElement)object).getId().equals(this.getId());
    }

    public String toString() {
        return DOMUtil.getCanonicalPath(this.getElement()) + "/@id[.='" + this.getId() + "']";
    }

    protected abstract Log getLogger();

    protected boolean isCancelled(Event event) {
        String s;
        return event.getCancelable() && this.element.hasAttributeNS("http://www.w3.org/2001/xml-events", "event") && (s = this.element.getAttributeNS("http://www.w3.org/2001/xml-events", "event")).equals(event.getType()) && this.element.getAttributeNS("http://www.w3.org/2001/xml-events", "defaultAction").equals("cancel");
    }

    public List evalInScopeContext() throws XFormsException {
        List resultNodeset;
        Binding parentBoundElement = this.getEnclosingBinding(this, false);
        if (parentBoundElement != null) {
            resultNodeset = parentBoundElement.getNodeset();
        } else if (this instanceof BindingElement && XPathUtil.isAbsolutePath(((BindingElement)this).getLocationPath())) {
            BindingElement binding = (BindingElement)this;
            resultNodeset = this.model.getInstance(binding.getInstanceId()).getInstanceNodeset();
        } else {
            resultNodeset = this.model.getDefaultInstance() != null ? this.model.getDefaultInstance().getInstanceNodeset() : Collections.EMPTY_LIST;
        }
        if (resultNodeset == null) {
            if (parentBoundElement == null) {
                return null;
            }
            this.getLogger().info((Object)("Context ResultSet is null for element: " + DOMUtil.getCanonicalPath(((XFormsElement)((Object)parentBoundElement)).getElement())));
            return Collections.EMPTY_LIST;
        }
        String contextExpression = this.getContextExpression();
        if (contextExpression == null || this.getXFormsAttribute("bind") != null) {
            return resultNodeset;
        }
        List contextResultNodeSet = XPathCache.getInstance().evaluate(resultNodeset, 1, contextExpression, this.getPrefixMapping(), this.xpathFunctionContext);
        if (contextResultNodeSet == null || contextResultNodeSet.size() == 0) {
            return contextResultNodeSet;
        }
        return Collections.singletonList(contextResultNodeSet.get(0));
    }

    public Binding getEnclosingBinding(XFormsElement xFormsElement, boolean returnBind) {
        Node parentNode;
        Binding enclosingBinding = null;
        Container container = xFormsElement.getContainerObject();
        Node currentNode = xFormsElement.getElement();
        String modelId = xFormsElement.getModel().getId();
        while ((parentNode = currentNode.getParentNode()) != null && parentNode instanceof Element) {
            Binding binding;
            Element elementImpl = (Element)parentNode;
            Object o = elementImpl.getUserData("");
            if (BindingResolver.hasModelBinding(elementImpl) && (binding = (Binding)o).getModelId().equals(modelId)) {
                String bindId = binding.getBindingId();
                if (returnBind) {
                    enclosingBinding = (Binding)((Object)container.lookup(bindId));
                    break;
                }
                enclosingBinding = binding;
                break;
            }
            Binding enclosingUIBinding = this.getEnclosingUIBinding(elementImpl, o, modelId);
            if (enclosingUIBinding != null) {
                enclosingBinding = enclosingUIBinding;
                break;
            }
            currentNode = parentNode;
        }
        return enclosingBinding;
    }

    public Binding getEnclosingUIBinding(Element elementImpl, Object binding, String modelId) {
        if (!(binding instanceof Binding)) {
            return null;
        }
        Binding bindingElem = (Binding)binding;
        if ((BindingResolver.hasUIBinding(elementImpl) || bindingElem instanceof Group && bindingElem.hasBindingExpression() || bindingElem instanceof RepeatItem || bindingElem instanceof Item && ((Item)bindingElem).getItemset() != null) && bindingElem.getModelId().equals(modelId)) {
            return bindingElem;
        }
        return null;
    }

    public XFormsElement getEnclosingXFormsContainer() {
        Node parentNode;
        Node currentNode = this.getElement();
        XFormsElement enclosingContainer = null;
        while ((parentNode = currentNode.getParentNode()) != null && parentNode instanceof Element) {
            Element elementImpl = (Element)parentNode;
            Object containerObject = elementImpl.getUserData("");
            if (containerObject instanceof Group || containerObject instanceof Switch || containerObject instanceof Repeat) {
                enclosingContainer = (XFormsElement)containerObject;
                break;
            }
            currentNode = parentNode;
        }
        return enclosingContainer;
    }

    public String getContextExpression() {
        return null;
    }
}

