/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms;

import de.betterform.connector.ConnectorFactory;
import de.betterform.session.DefaultSerializer;
import de.betterform.xml.config.Config;
import de.betterform.xml.config.XFormsConfigException;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.events.impl.DefaultXMLEventInitializer;
import de.betterform.xml.events.impl.DefaultXMLEventService;
import de.betterform.xml.events.impl.XercesXMLEventFactory;
import de.betterform.xml.xforms.Container;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.XFormsProcessor;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.ui.AbstractFormControl;
import de.betterform.xml.xforms.ui.Repeat;
import de.betterform.xml.xforms.ui.Upload;
import java.io.BufferedInputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.xforms.XFormsModelElement;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XFormsProcessorImpl
implements XFormsProcessor,
Externalizable {
    public static final String BETTERFORM_LOCALE = "betterform.locale";
    public static final String BETTERFORM_ENABLE_L10N = "enable.l10n";
    private static final Log LOGGER = LogFactory.getLog(XFormsProcessorImpl.class);
    private static String APP_INFO = null;
    private static final long serialVersionUID = 1L;
    private Container container = null;
    private String baseURI = null;
    private Map context = null;
    private ArrayList eventList;

    public ArrayList getEventList() {
        return this.eventList;
    }

    public XFormsProcessorImpl() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)XFormsProcessorImpl.getAppInfo());
        }
        this.context = new HashMap(10);
        this.context.put("versionInfo", XFormsProcessorImpl.getAppInfo());
        this.eventList = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAppInfo() {
        Class<XFormsProcessorImpl> clazz = XFormsProcessorImpl.class;
        synchronized (XFormsProcessorImpl.class) {
            if (APP_INFO == null) {
                try {
                    int c;
                    BufferedInputStream stream = new BufferedInputStream(XFormsProcessorImpl.class.getResourceAsStream("/META-INF/version.info"));
                    StringBuffer buffer = new StringBuffer();
                    while ((c = stream.read()) > -1) {
                        if (c == 10 || c == 13) continue;
                        buffer.append((char)c);
                    }
                    stream.close();
                    APP_INFO = buffer.toString();
                }
                catch (IOException e) {
                    APP_INFO = "betterFORM";
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return APP_INFO;
        }
    }

    @Override
    public void setConfigPath(String path) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("set config: " + path));
        }
        if (path == null || !new File(path).exists()) {
            throw new XFormsConfigException("path not found: " + path);
        }
        Config.getInstance(path);
    }

    @Override
    public void setBaseURI(String uri) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("set base uri: " + uri));
        }
        this.context.put("betterform.baseURI", uri);
        this.baseURI = uri;
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    @Override
    public void setContext(Map context) {
        this.context = context;
    }

    public Map getContext() {
        if (this.context == null) {
            this.context = new HashMap();
        }
        return this.context;
    }

    @Override
    public Object getContextParam(String key) {
        return this.getContext().get(key);
    }

    @Override
    public Object removeContextParam(String key) {
        return this.getContext().remove(key);
    }

    @Override
    public void setContextParam(String key, Object object) {
        this.getContext().put(key, object);
    }

    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setXForms(Node node) throws XFormsException {
        this.ensureContainerNotInitialized();
        Document document = this.toDocument(node);
        this.createContainer().setDocument(document);
    }

    @Override
    public void setXForms(URI uri) throws XFormsException {
        this.ensureContainerNotInitialized();
        String absoluteURI = this.resolve(uri);
        ConnectorFactory connectorFactory = ConnectorFactory.getFactory();
        connectorFactory.setContext(this.getContext());
        Node node = (Node)connectorFactory.createURIResolver(absoluteURI, null).resolve();
        Document document = this.toDocument(node);
        this.createContainer().setDocument(document);
    }

    @Override
    public void setXForms(InputStream stream) throws XFormsException {
        Document document;
        this.ensureContainerNotInitialized();
        try {
            document = this.getDocumentBuilder().parse(stream);
        }
        catch (Exception e) {
            throw new XFormsException("could not create document container", e);
        }
        this.createContainer().setDocument(document);
    }

    @Override
    public void setXForms(InputSource source) throws XFormsException {
        Document document;
        this.ensureContainerNotInitialized();
        try {
            document = this.getDocumentBuilder().parse(source);
        }
        catch (Exception e) {
            throw new XFormsException("could not create document container", e);
        }
        this.createContainer().setDocument(document);
    }

    @Override
    public XFormsModelElement getXFormsModel(String id) throws XFormsException {
        this.ensureContainerPresent();
        return this.container.getModel(id);
    }

    @Override
    public Document getXForms() throws XFormsException {
        this.ensureContainerPresent();
        return this.container.getDocument();
    }

    public Document getInstanceDocument(String id) throws DOMException {
        try {
            this.ensureContainerInitialized();
        }
        catch (XFormsException e) {
            throw new DOMException(11, "Processor is not intialized");
        }
        List models = this.container.getModels();
        Document instance = null;
        for (int i = 0; i < models.size(); ++i) {
            Model model = (Model)models.get(i);
            instance = model.getInstanceDocument(id);
            if (instance == null) continue;
            return instance;
        }
        throw new DOMException(8, "Instance with id: '" + id + "' not found");
    }

    @Override
    public void init() throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"init");
        }
        this.ensureContainerPresent();
        this.ensureContainerNotInitialized();
        if (!this.getContext().containsKey(BETTERFORM_LOCALE)) {
            this.setLocale();
        }
        this.container.init();
    }

    @Override
    public boolean dispatch(String id, String event) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("dispatch: id: " + id + ", event: " + event));
        }
        this.ensureContainerPresent();
        this.ensureContainerInitialized();
        return this.container.dispatch(id, event);
    }

    @Override
    public boolean dispatch(String targetId, String eventType, Object info, boolean bubbles, boolean cancelable) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("dispatch: id: " + targetId + ", event: " + eventType + ", contextinfo: " + info.toString()));
        }
        this.ensureContainerPresent();
        this.ensureContainerInitialized();
        return this.container.dispatch(targetId, eventType, info, bubbles, cancelable);
    }

    @Override
    public XFormsElement lookup(String id) {
        return this.container.lookup(id);
    }

    @Override
    public void handleEventException(Exception e) {
        this.container.handleEventException(e);
    }

    public final boolean hasControlChanged(String id, String value) throws XFormsException {
        this.ensureContainerPresent();
        this.ensureContainerInitialized();
        XFormsElement element = this.container.lookup(id);
        if (element == null || !(element instanceof AbstractFormControl)) {
            throw new XFormsException("id '" + id + "' does not identify a form control");
        }
        AbstractFormControl control = (AbstractFormControl)element;
        Object controlValue = control.getValue();
        if (controlValue == null) {
            return false;
        }
        return !controlValue.equals(value);
    }

    @Override
    public final boolean isFileUpload(String id, String type) throws XFormsException {
        return this.hasControlType(id, type);
    }

    public final boolean hasControlType(String id, String type) throws XFormsException {
        this.ensureContainerPresent();
        this.ensureContainerInitialized();
        XFormsElement element = this.container.lookup(id);
        if (element == null || !(element instanceof AbstractFormControl)) {
            throw new XFormsException("id '" + id + "' does not identify a form control");
        }
        String datatype = ((AbstractFormControl)element).getDatatype();
        if (datatype != null) {
            return element.getModel().getValidator().isRestricted(type, datatype);
        }
        return false;
    }

    @Override
    public final void setControlValue(String id, String value) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("update control value: id: " + id + ", value: " + value));
        }
        this.ensureContainerPresent();
        this.ensureContainerInitialized();
        XFormsElement element = this.container.lookup(id);
        if (element == null || !(element instanceof AbstractFormControl)) {
            throw new XFormsException("id '" + id + "' does not identify a form control");
        }
        if (element instanceof Upload) {
            throw new XFormsException("upload cannot be updated with this method - at: " + DOMUtil.getCanonicalPath(element.getElement()));
        }
        AbstractFormControl control = (AbstractFormControl)element;
        control.setValue(value);
    }

    @Override
    public final void setUploadValue(String id, String mediatype, String filename, byte[] data) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("update control value: id: " + id + ", mediatype: " + mediatype + ", filename: " + filename + ", data: " + (data != null ? data.length + " bytes" : "null")));
        }
        this.ensureContainerPresent();
        this.ensureContainerInitialized();
        XFormsElement element = this.container.lookup(id);
        if (element == null || !(element instanceof Upload)) {
            throw new XFormsException("id '" + id + "' does not identify an upload control");
        }
        Upload upload = (Upload)element;
        upload.setValue(data, filename, mediatype);
    }

    @Override
    public void setRepeatIndex(String id, int index) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("set repeat index: id: " + id + ", index: " + index));
        }
        this.ensureContainerPresent();
        this.ensureContainerInitialized();
        XFormsElement element = this.container.lookup(id);
        if (element == null || !(element instanceof Repeat)) {
            throw new XFormsException("id '" + id + "' does not identify a repeat");
        }
        Repeat repeat = (Repeat)element;
        repeat.setIndex(index);
        Model model = repeat.getModel();
        this.container.dispatch(model.getTarget(), "xforms-rebuild", null);
        this.container.dispatch(model.getTarget(), "xforms-recalculate", null);
        this.container.dispatch(model.getTarget(), "xforms-revalidate", null);
        this.container.dispatch(model.getTarget(), "xforms-refresh", null);
    }

    @Override
    public void shutdown() throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"shutdown");
        }
        if (this.container != null) {
            this.container.shutdown();
            this.container = null;
        } else {
            LOGGER.warn((Object)"shutdown: container not present");
        }
    }

    @Override
    public void setLocale(String lang) throws XFormsException {
        this.addLocaleToContext(lang);
        if (this.container != null) {
            this.container.refresh();
        }
    }

    protected void setLocale() throws XFormsException {
        String configuredLocale = null;
        configuredLocale = Config.getInstance().getProperty("language");
        this.addLocaleToContext(configuredLocale);
    }

    private void addLocaleToContext(String lang) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("setting locale to: " + lang));
        }
        try {
            this.getContext().put(BETTERFORM_LOCALE, new Locale(lang));
            this.getContext().put("lang", lang);
        }
        catch (NullPointerException e) {
            LOGGER.warn((Object)("No configuration property for 'language' found - using default VM locale: " + Locale.getDefault().toString()));
            this.addLocaleToContext(Locale.getDefault().getLanguage());
        }
    }

    private Container createContainer() {
        DefaultXMLEventService eventService = new DefaultXMLEventService();
        eventService.setXMLEventFactory(new XercesXMLEventFactory());
        eventService.setXMLEventInitializer(new DefaultXMLEventInitializer());
        this.container = new Container(this);
        this.container.setXMLEventService(eventService);
        return this.container;
    }

    private Document toDocument(Node node) throws XFormsException {
        if (node instanceof Document) {
            return (Document)node;
        }
        Document document = this.getDocumentBuilder().newDocument();
        if (node instanceof Document) {
            node = ((Document)node).getDocumentElement();
        }
        document.appendChild(document.importNode(node, true));
        return document;
    }

    private DocumentBuilder getDocumentBuilder() throws XFormsException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder db = factory.newDocumentBuilder();
            db.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return null;
                }
            });
            return db;
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    private void ensureContainerPresent() throws XFormsException {
        if (this.container == null) {
            throw new XFormsException("document container not present");
        }
    }

    private void ensureContainerInitialized() throws XFormsException {
        if (this.container == null || !this.container.isModelConstructDone()) {
            throw new XFormsException("document container not initialized");
        }
    }

    private void ensureContainerNotInitialized() throws XFormsException {
        if (this.container != null && this.container.isModelConstructDone() && this.getXForms().getDocumentElement().hasAttributeNS("http://betterform.sourceforge.net/xforms", "serialized")) {
            LOGGER.debug((Object)"FORM WAS SERIALIZED");
        }
    }

    private String resolve(URI relative) throws XFormsException {
        if (relative.isAbsolute() || relative.isOpaque()) {
            return relative.toString();
        }
        if (this.baseURI == null) {
            throw new XFormsException("base uri not present");
        }
        try {
            return new URI(this.baseURI).resolve(relative).toString();
        }
        catch (URISyntaxException e) {
            throw new XFormsException(e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        block8: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"serializing XFormsFormsProcessorImpl");
            }
            try {
                if (this.getXForms().getDocumentElement().hasAttribute("bf:serialized")) {
                    objectOutput.writeUTF(DOMUtil.serializeToString(this.getXForms()));
                    break block8;
                }
                this.getXForms().getDocumentElement().setAttributeNS("http://betterform.sourceforge.net/xforms", "bf:baseURI", this.getBaseURI());
                this.getXForms().getDocumentElement().setAttributeNS("http://betterform.sourceforge.net/xforms", "bf:serialized", "true");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"....::: XForms before writing ::::....");
                    DOMUtil.prettyPrintDOM(this.getXForms());
                }
                DefaultSerializer serializer = new DefaultSerializer(this);
                Document serializedForm = serializer.serialize();
                StringWriter stringWriter = new StringWriter();
                Transformer transformer = null;
                StreamResult result = new StreamResult(stringWriter);
                try {
                    transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty("method", "xml");
                    transformer.transform(new DOMSource(serializedForm), result);
                }
                catch (TransformerConfigurationException e) {
                    throw new IOException("TransformerConfiguration invalid: " + e.getMessage());
                }
                catch (TransformerException e) {
                    throw new IOException("Error during serialization transform: " + e.getMessage());
                }
                objectOutput.writeUTF(stringWriter.getBuffer().toString());
            }
            catch (XFormsException e) {
                throw new IOException("baseURI couldn't be set");
            }
        }
        objectOutput.flush();
        objectOutput.close();
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"deserializing XForms host document");
        }
        String read = objectInput.readUTF();
        Document host = null;
        try {
            host = DOMUtil.parseString(read, true, false);
            String baseURI = host.getDocumentElement().getAttribute("bf:baseURI");
            this.setContextParam("betterform.baseURI", baseURI);
            this.setBaseURI(baseURI);
            this.setXForms(host.getDocumentElement());
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Parser misconfigured: " + e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException("Parsing failed: " + e.getMessage());
        }
        catch (XFormsException e) {
            throw new IOException("An XForms error occurred when passing the host document: " + e.getMessage());
        }
    }
}

