/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.action;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.action.UpdateHandler;
import de.betterform.xml.xforms.action.XFormsAction;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.bind.Binding;
import de.betterform.xml.xforms.model.bind.BindingResolver;
import de.betterform.xml.xforms.ui.Group;
import de.betterform.xml.xforms.ui.Item;
import de.betterform.xml.xforms.ui.RepeatItem;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.om.NodeInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public abstract class AbstractAction
extends XFormsElement
implements EventListener,
XFormsAction {
    private static final Log LOGGER = LogFactory.getLog(AbstractAction.class);
    protected int position = 1;
    protected String repeatItemId;
    protected String eventType;
    protected String eventTargetId;
    protected String phase;
    protected String propagate;
    protected String defaultAction;

    public AbstractAction(Element element, Model model) {
        super(element, model);
    }

    public void setRepeatItemId(String repeatItemId) throws XFormsException {
        this.repeatItemId = repeatItemId;
    }

    public String getRepeatItemId() {
        return this.repeatItemId;
    }

    public boolean isRepeated() {
        return this.repeatItemId != null;
    }

    @Override
    public void init() throws XFormsException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)(this + " init"));
        }
        this.initializeAction();
    }

    @Override
    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeAction();
    }

    private final void initializeAction() throws XFormsException {
        if (!(this.getParentObject() instanceof XFormsAction)) {
            XFormsElement xformsElement;
            String handler;
            String event = this.element.getAttributeNS("http://www.w3.org/2001/xml-events", "event");
            if (event.length() == 0) {
                event = "DOMActivate";
            }
            this.eventType = event;
            String observer = this.element.getAttributeNS("http://www.w3.org/2001/xml-events", "observer");
            this.eventTargetId = this.element.getAttributeNS("http://www.w3.org/2001/xml-events", "target");
            this.phase = this.element.getAttributeNS("http://www.w3.org/2001/xml-events", "phase");
            if (this.phase.equals("")) {
                this.phase = "default";
            }
            this.propagate = this.element.getAttributeNS("http://www.w3.org/2001/xml-events", "propagate");
            if (this.propagate.equals("")) {
                this.propagate = "continue";
            }
            this.defaultAction = this.element.getAttributeNS("http://www.w3.org/2001/xml-events", "defaultAction");
            if (this.defaultAction.equals("")) {
                this.defaultAction = "perform";
            }
            if ((handler = this.element.getAttributeNS("http://www.w3.org/2001/xml-events", "handler")) != null && !handler.equals("")) {
                LOGGER.warn((Object)("Attribute 'handler' for " + DOMUtil.getCanonicalPath(this.element) + " ignored (not implemented yet)"));
            }
            EventTarget targetElement = null;
            if (this.eventTargetId != null && !this.eventTargetId.equals("")) {
                xformsElement = this.container.lookup(this.eventTargetId);
                if (xformsElement != null) {
                    targetElement = xformsElement.getTarget();
                } else {
                    targetElement = (EventTarget)((Object)XPathUtil.getAsNode(XPathUtil.evaluate(this.container.getDocument(), "//*[@id eq '" + this.eventTargetId + "']"), 1));
                    if (targetElement == null) {
                        throw new XFormsException("targetElement with id '" + this.eventTargetId + "' is not present in this form");
                    }
                }
                this.addListener(targetElement);
            }
            if (observer != null && !observer.equals("")) {
                xformsElement = this.container.lookup(observer);
                if (xformsElement != null) {
                    targetElement = xformsElement.getTarget();
                } else {
                    targetElement = (EventTarget)((Object)XPathUtil.getAsNode(XPathUtil.evaluate(this.container.getDocument(), "//*[@id eq '" + observer + "']"), 1));
                    if (targetElement == null) {
                        throw new XFormsException("targetElement with id '" + observer + "' is not present in this form");
                    }
                }
                this.addListener(targetElement);
            } else {
                XFormsElement parent = this.getParentObject();
                if (parent != null) {
                    targetElement = parent.getTarget();
                    this.addListener(targetElement);
                } else {
                    this.getLogger().warn((Object)"parent is null");
                }
            }
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace((Object)(this + " init: added handler for event '" + this.eventType + "' to " + DOMUtil.getCanonicalPath(this.element)));
            }
        }
    }

    private void addListener(EventTarget targetElement) {
        this.addEventToUsedEvents();
        if (this.phase.equals("capture")) {
            targetElement.addEventListener(this.eventType, this, true);
        } else {
            targetElement.addEventListener(this.eventType, this, false);
        }
    }

    private void addEventToUsedEvents() {
        ArrayList usedEvents = this.container.getProcessor().getEventList();
        if (!usedEvents.contains(this.eventType)) {
            usedEvents.add(this.eventType);
        }
    }

    protected final void disposeAction() {
        if (!(this.getParentObject() instanceof XFormsAction)) {
            XFormsElement parent = this.getParentObject();
            parent.getTarget().removeEventListener(this.eventType, this, false);
        }
    }

    @Override
    public final void handleEvent(Event event) {
        try {
            if (event.getType().equals(this.eventType)) {
                boolean doPerform = false;
                if (this.propagate.equals("stop")) {
                    event.stopPropagation();
                }
                if (this.defaultAction.equals("cancel")) {
                    event.preventDefault();
                }
                if (this.getLogger().isTraceEnabled()) {
                    String currentEventId = ((Element)((Object)event.getCurrentTarget())).getAttribute("id");
                    String targetEventId = ((Element)((Object)event.getTarget())).getAttribute("id");
                    LOGGER.trace((Object)("currentEventTargetId: '" + currentEventId + "' eventTargetId:'" + targetEventId + "'"));
                    this.getLogger().trace((Object)("handling event '" + this.eventType + "' target: " + DOMUtil.getCanonicalPath(this.element) + "' Event Phase: (" + event.getEventPhase() + ")"));
                }
                if (this.getLogger().isDebugEnabled()) {
                    switch (event.getEventPhase()) {
                        case 1: {
                            if (!this.getLogger().isDebugEnabled()) break;
                            this.getLogger().debug((Object)"CAPTURING PHASE");
                            break;
                        }
                        case 2: {
                            if (!this.getLogger().isDebugEnabled()) break;
                            this.getLogger().debug((Object)"AT_TARGET");
                            break;
                        }
                        case 3: {
                            if (!this.getLogger().isDebugEnabled()) break;
                            this.getLogger().debug((Object)"BUBBLING");
                        }
                    }
                }
                if (event.getEventPhase() == 1 && this.phase.equals("capture")) {
                    doPerform = true;
                } else if (event.getEventPhase() == 2) {
                    doPerform = true;
                } else if (event.getEventPhase() == 3) {
                    doPerform = true;
                }
                String targetEventId = ((Element)((Object)event.getTarget())).getAttribute("id");
                if (!this.eventTargetId.equals("")) {
                    doPerform = event.getType().equals(this.eventType) && targetEventId.equals(this.eventTargetId);
                }
                if (doPerform) {
                    this.performConditional(this.element);
                }
            }
        }
        catch (Exception e) {
            this.container.handleEventException(e);
            event.preventDefault();
            event.stopPropagation();
        }
    }

    protected void performConditional(Element actionEl) throws XFormsException {
        XFormsAction action = (XFormsAction)actionEl.getUserData("");
        String whileCondition = XFormsElement.getXFormsAttribute(actionEl, "while");
        if (whileCondition == null) {
            if (this.execute((AbstractAction)action)) {
                action.perform();
            }
        } else {
            while (this.evalCondition(whileCondition) && this.execute((AbstractAction)action)) {
                action.perform();
            }
        }
    }

    protected boolean execute(AbstractAction action) throws XFormsException {
        String ifCondition = AbstractAction.getXFormsAttribute(action.getElement(), "if");
        if (ifCondition == null) {
            return true;
        }
        return action.evalCondition(ifCondition);
    }

    protected boolean evalCondition(String condition) throws XFormsException {
        List resultNodeset = this.evalInScopeContext();
        String relativeExpr = condition;
        try {
            String result = XPathCache.getInstance().evaluateAsString(resultNodeset, this.position, condition, this.getPrefixMapping(), this.xpathFunctionContext);
            boolean b = result.equalsIgnoreCase("true");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("evaluating " + relativeExpr + " in context '" + ((NodeInfo)resultNodeset.get(0)).getDisplayName() + "' to " + b));
            }
            return b;
        }
        catch (XFormsException e) {
            throw new XFormsException(e);
        }
    }

    protected final void doRebuild(boolean rebuild) throws XFormsException {
        UpdateHandler updateHandler = this.model.getUpdateHandler();
        if (updateHandler != null) {
            updateHandler.doRebuild(rebuild);
            return;
        }
        if (rebuild) {
            this.container.dispatch(this.model.getTarget(), "xforms-rebuild", null);
        }
    }

    protected final void doRecalculate(boolean recalculate) throws XFormsException {
        UpdateHandler updateHandler = this.model.getUpdateHandler();
        if (updateHandler != null) {
            updateHandler.doRecalculate(recalculate);
            return;
        }
        if (recalculate) {
            this.container.dispatch(this.model.getTarget(), "xforms-recalculate", null);
        }
    }

    protected final void doRevalidate(boolean revalidate) throws XFormsException {
        UpdateHandler updateHandler = this.model.getUpdateHandler();
        if (updateHandler != null) {
            updateHandler.doRevalidate(revalidate);
            return;
        }
        if (revalidate) {
            this.container.dispatch(this.model.getTarget(), "xforms-revalidate", null);
        }
    }

    protected final void doRefresh(boolean refresh) throws XFormsException {
        UpdateHandler updateHandler = this.model.getUpdateHandler();
        if (updateHandler != null) {
            updateHandler.doRefresh(refresh);
            return;
        }
        if (refresh) {
            this.container.dispatch(this.model.getTarget(), "xforms-refresh", null);
        }
    }

    @Override
    public Binding getEnclosingUIBinding(Element elementImpl, Object binding, String modelId) {
        if (!(binding instanceof Binding)) {
            return null;
        }
        Binding bindingElem = (Binding)binding;
        if ((BindingResolver.hasUIBinding(elementImpl) || bindingElem instanceof Group && bindingElem.hasBindingExpression() && !(bindingElem instanceof RepeatItem) || bindingElem instanceof Item && ((Item)bindingElem).getItemset() != null) && bindingElem.getModelId().equals(modelId)) {
            return bindingElem;
        }
        return null;
    }
}

