/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.action;

import de.betterform.xml.xforms.Initializer;
import de.betterform.xml.xforms.action.AbstractAction;
import de.betterform.xml.xforms.action.UpdateHandler;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActionAction
extends AbstractAction {
    private static final Log LOGGER = LogFactory.getLog(ActionAction.class);

    public ActionAction(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void init() throws XFormsException {
        super.init();
        Initializer.initializeActionElements(this.model, this.element, this.repeatItemId);
    }

    @Override
    public void perform() throws XFormsException {
        boolean outermost = false;
        UpdateHandler updateHandler = this.model.getUpdateHandler();
        if (updateHandler == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " perform: starting outermost action handler for " + this.model));
            }
            updateHandler = new UpdateHandler(this.model);
            this.model.setUpdateHandler(updateHandler);
            outermost = true;
        }
        NodeList childNodes = this.element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1) continue;
            this.performConditional((Element)node);
        }
        if (outermost) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " perform: terminating outermost action handler for " + this.model));
            }
            this.model.setUpdateHandler(null);
            updateHandler.doUpdate();
        }
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

