/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.action;

import de.betterform.xml.xforms.action.AbstractBoundAction;
import de.betterform.xml.xforms.exception.XFormsComputeException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Instance;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeleteAction
extends AbstractBoundAction {
    private static final Log LOGGER = LogFactory.getLog(DeleteAction.class);
    private String atAttribute;

    public DeleteAction(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void init() throws XFormsException {
        super.init();
        this.atAttribute = this.getXFormsAttribute("at");
    }

    @Override
    public String getContextExpression() {
        return this.getXFormsAttribute("context");
    }

    @Override
    public void perform() throws XFormsException {
        this.updateXPathContext();
        int nrOfNodesInNodeset = this.nodeset.size();
        if (nrOfNodesInNodeset == 0) {
            this.getLogger().warn((Object)(this + " perform: nodeset '" + this.getLocationPath() + "' is empty"));
            return;
        }
        if (this.atAttribute == null) {
            Instance instance = this.model.getInstance(this.getInstanceId());
            String locationPath = this.getLocationPath();
            String path = locationPath + "[1]";
            for (int i = 0; i < this.nodeset.size(); ++i) {
                if (instance.deleteNode(XPathUtil.getAsNode(this.nodeset, i + 1), path)) continue;
                return;
            }
            this.container.dispatch(instance.getTarget(), "xforms-delete", this.constructEventInfo(Double.NaN, this.nodeset, locationPath));
        } else {
            String positionInNodeset;
            Node target;
            List deleteNodes;
            if (this.atAttribute.equals("last()")) {
                deleteNodes = Collections.singletonList(this.nodeset.get(nrOfNodesInNodeset - 1));
                target = XPathUtil.getAsNode(this.nodeset, nrOfNodesInNodeset);
                positionInNodeset = Integer.toString(nrOfNodesInNodeset);
            } else {
                Double d;
                try {
                    d = XPathCache.getInstance().evaluateAsDouble(this.nodeset, this.position, "round(number(" + this.atAttribute + "))", this.getPrefixMapping(), this.xpathFunctionContext);
                }
                catch (Exception e) {
                    throw new XFormsComputeException("invalid 'at' expression at " + this, e, this.target, this.atAttribute);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("bound to: " + this.getBindingExpression()));
                    LOGGER.debug((Object)("value attribute evaluated to: " + d));
                }
                long position = Math.round(d);
                if (Double.isNaN(d) || position > (long)nrOfNodesInNodeset) {
                    position = nrOfNodesInNodeset;
                } else if (position < 1L) {
                    position = 1L;
                }
                deleteNodes = Collections.singletonList(this.nodeset.get((int)position - 1));
                target = XPathUtil.getAsNode(this.nodeset, (int)position);
                positionInNodeset = Long.toString(position);
            }
            Instance instance = this.model.getInstance(this.getInstanceId());
            String path = this.getLocationPath() + "[" + positionInNodeset + "]";
            if (!instance.deleteNode(target, path)) {
                return;
            }
            this.container.dispatch(instance.getTarget(), "xforms-delete", this.constructEventInfo(Double.valueOf(positionInNodeset), deleteNodes, path));
        }
        this.doRebuild(true);
        this.doRecalculate(true);
        this.doRevalidate(true);
        this.doRefresh(true);
    }

    private Map<String, Object> constructEventInfo(Double positionInNodeset, List deleteNodes, String path) {
        HashMap<String, Object> eventInfo = new HashMap<String, Object>();
        eventInfo.put("path", path);
        eventInfo.put("delete-location", positionInNodeset);
        eventInfo.put("deleted-nodes", deleteNodes);
        return eventInfo;
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

