/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.action;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.action.AbstractBoundAction;
import de.betterform.xml.xforms.exception.XFormsBindingException;
import de.betterform.xml.xforms.exception.XFormsComputeException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Instance;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.bind.BindingUtil;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.dom.DOMNodeWrapper;
import net.sf.saxon.om.Item;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InsertAction
extends AbstractBoundAction {
    private static final Log LOGGER = LogFactory.getLog(InsertAction.class);
    protected IInsertAction insertaction;

    public InsertAction(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void init() throws XFormsException {
        super.init();
        this.insertaction = this.container.getVersion().equals("1.0") ? new InsertAction10() : new InsertAction11();
        this.insertaction.init();
    }

    @Override
    public String getBindingExpression() {
        return this.insertaction.getBindingExpression();
    }

    @Override
    public String getContextExpression() {
        return this.getXFormsAttribute("context");
    }

    @Override
    public void perform() throws XFormsException {
        this.updateXPathContext();
        this.insertaction.perform();
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }

    private class InsertAction11
    extends InsertAction10 {
        private InsertAction11() {
        }

        @Override
        public void init() throws XFormsException {
            this.atAttribute = InsertAction.this.getXFormsAttribute("at");
            if (this.atAttribute == null) {
                this.atAttribute = "last()";
                LOGGER.info((Object)"No 'at' attribute present, defaulting to last()");
            }
            this.positionAttribute = InsertAction.this.getXFormsAttribute("position");
            if (this.positionAttribute == null) {
                this.positionAttribute = "after";
                LOGGER.info((Object)"No 'position' attribute present, defaulting to after");
            }
            this.originAttribute = InsertAction.this.getXFormsAttribute("origin");
        }

        @Override
        public void perform() throws XFormsException {
            int insertPositionFirstNode;
            Node insertLocationNode;
            List nodeSetBindingNodeSet;
            if (InsertAction.this.evalInscopeContext.size() == 0) {
                InsertAction.this.getLogger().warn((Object)(this + " perform: nodeset inscope evaluation context is empty"));
                return;
            }
            boolean hasNodeSetBinding = this.getBindingExpression() != null;
            List list = nodeSetBindingNodeSet = InsertAction.this.hasModelBinding() ? InsertAction.this.nodeset : InsertAction.this.evalInscopeContext;
            if (nodeSetBindingNodeSet.isEmpty() && (InsertAction.this.getContextExpression() == null || InsertAction.this.getContextExpression() != null && !(XPathUtil.getAsNode(InsertAction.this.evalInscopeContext, 1) instanceof Element))) {
                InsertAction.this.getLogger().warn((Object)(this + " perform: nodeset '" + InsertAction.this.getLocationPath() + "' is empty"));
                return;
            }
            int nrOfNodesInNodeSet = InsertAction.this.nodeset.size();
            List originNodeSet = this.originAttribute == null ? (InsertAction.this.nodeset.isEmpty() ? Collections.EMPTY_LIST : Collections.singletonList(InsertAction.this.nodeset.get(nrOfNodesInNodeSet - 1))) : XPathCache.getInstance().evaluate(InsertAction.this.evalInscopeContext, 1, this.originAttribute, InsertAction.this.getPrefixMapping(), InsertAction.this.xpathFunctionContext);
            if (originNodeSet.isEmpty()) {
                InsertAction.this.getLogger().warn((Object)(this + " perform: origin nodeset of insert is empty"));
                return;
            }
            if (!hasNodeSetBinding || InsertAction.this.nodeset.isEmpty()) {
                insertLocationNode = XPathUtil.getAsNode(InsertAction.this.evalInscopeContext, 1);
                insertPositionFirstNode = 1;
            } else {
                insertPositionFirstNode = this.computeInsertPosition(nrOfNodesInNodeSet, false);
                insertLocationNode = XPathUtil.getAsNode(InsertAction.this.nodeset, insertPositionFirstNode);
            }
            Instance instance = InsertAction.this.model.getInstance(InsertAction.this.getInstanceId());
            ArrayList<Node> insertedNodes = new ArrayList<Node>();
            Node beforeNode = null;
            for (int i = 0; i < originNodeSet.size(); ++i) {
                Node parentNode;
                Node originNode = XPathUtil.getAsNode(originNodeSet, i + 1);
                if (InsertAction.this.getContextExpression() == null && originNode.getNodeType() == 2) {
                    return;
                }
                if (!hasNodeSetBinding || InsertAction.this.nodeset.isEmpty()) {
                    parentNode = XPathUtil.getAsNode(InsertAction.this.evalInscopeContext, 1);
                    if (insertLocationNode.getNodeType() != 1) continue;
                    if (parentNode.getNodeType() == 9 && originNode.getNodeType() == 1) {
                        parentNode.removeChild(((Document)parentNode).getDocumentElement());
                    }
                    if (i == 0) {
                        beforeNode = parentNode.getFirstChild();
                    }
                } else {
                    if (originNode.getNodeType() == 2) {
                        parentNode = insertLocationNode;
                    } else {
                        parentNode = insertLocationNode.getParentNode();
                        if (parentNode.getNodeType() == 9 && originNode.getNodeType() == 1) {
                            parentNode.removeChild(((Document)parentNode).getDocumentElement());
                        }
                    }
                    if (i == 0) {
                        if ("after".equals(this.positionAttribute)) {
                            beforeNode = insertLocationNode.getNextSibling();
                            ++insertPositionFirstNode;
                        } else {
                            beforeNode = insertLocationNode;
                        }
                    }
                }
                insertedNodes.add(instance.insertNode(parentNode.getNodeType() != 2 ? parentNode : ((Attr)parentNode).getOwnerElement(), originNode, beforeNode));
            }
            InsertAction.this.container.dispatch(instance.getTarget(), "xforms-insert", this.createEventInfoObject(insertedNodes, originNodeSet, insertLocationNode, this.positionAttribute, InsertAction.this.getLocationPath() + "[" + (insertPositionFirstNode + originNodeSet.size() - 1) + "]"));
            InsertAction.this.doRebuild(true);
            InsertAction.this.doRecalculate(true);
            InsertAction.this.doRevalidate(true);
            InsertAction.this.doRefresh(true);
        }

        private Map<String, Object> createEventInfoObject(List<Node> insertedNodes, List<Item> originNodeSet, Node insertLocationNode, String positionAttribute, String locationPath) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            ArrayList<DOMNodeWrapper> insertedItems = new ArrayList<DOMNodeWrapper>(insertedNodes.size());
            for (int i = 0; i < insertedNodes.size(); ++i) {
                Node n = insertedNodes.get(i);
                insertedItems.add(InsertAction.this.container.getDocumentWrapper(n).wrap(n));
            }
            result.put("location-path", locationPath);
            result.put("inserted-nodes", insertedItems);
            result.put("origin-nodes", originNodeSet);
            result.put("insert-location-node", InsertAction.this.container.getDocumentWrapper(insertLocationNode).wrap(insertLocationNode));
            result.put("position", positionAttribute);
            return result;
        }
    }

    private class InsertAction10
    implements IInsertAction {
        protected String atAttribute;
        protected String positionAttribute;
        protected String originAttribute;

        private InsertAction10() {
        }

        @Override
        public void init() throws XFormsException {
            this.atAttribute = InsertAction.this.getXFormsAttribute("at");
            if (this.atAttribute == null) {
                throw new XFormsBindingException("missing at attribute at " + DOMUtil.getCanonicalPath(InsertAction.this.getElement()), InsertAction.this.target, null);
            }
            this.positionAttribute = InsertAction.this.getXFormsAttribute("position");
            if (this.positionAttribute == null) {
                throw new XFormsBindingException("missing position attribute at " + DOMUtil.getCanonicalPath(InsertAction.this.getElement()), InsertAction.this.target, null);
            }
            this.originAttribute = InsertAction.this.getXFormsAttribute("origin");
        }

        @Override
        public String getBindingExpression() {
            if (InsertAction.this.hasModelBinding()) {
                return InsertAction.this.getModelBinding().getBindingExpression();
            }
            if (BindingUtil.hasRef(InsertAction.this.element)) {
                return InsertAction.this.getXFormsAttribute("ref");
            }
            return InsertAction.this.getXFormsAttribute("nodeset");
        }

        @Override
        public void perform() throws XFormsException {
            Node beforeNode;
            int contextSize = InsertAction.this.nodeset.size();
            if (contextSize == 0) {
                InsertAction.this.getLogger().warn((Object)(InsertAction.this + " perform: nodeset '" + InsertAction.this.getLocationPath() + "' is empty"));
                return;
            }
            long insertPosition = this.computeInsertPosition(contextSize, true);
            Node parentNode = XPathUtil.getAsNode(InsertAction.this.nodeset, InsertAction.this.getPosition()).getParentNode();
            Node originNode = this.originAttribute == null ? XPathUtil.getAsNode(InsertAction.this.nodeset, Math.max(1, contextSize)) : XPathCache.getInstance().evaluateAsSingleNode(InsertAction.this.nodeset, InsertAction.this.position, this.originAttribute, InsertAction.this.getPrefixMapping(), InsertAction.this.xpathFunctionContext);
            Node node = beforeNode = insertPosition > (long)contextSize ? null : XPathUtil.getAsNode(InsertAction.this.nodeset, (int)insertPosition);
            if (beforeNode == null && contextSize > 0) {
                beforeNode = XPathUtil.getAsNode(InsertAction.this.nodeset, contextSize).getNextSibling();
            }
            if (originNode == null) {
                InsertAction.this.getLogger().warn((Object)(InsertAction.this + " perform: origin nodeset of insert is empty"));
                return;
            }
            Instance instance = InsertAction.this.model.getInstance(InsertAction.this.getInstanceId());
            instance.insertNode(parentNode, originNode, beforeNode);
            InsertAction.this.container.dispatch(instance.getTarget(), "xforms-insert", (Object)(InsertAction.this.getLocationPath() + "[" + insertPosition + "]"));
            InsertAction.this.doRebuild(true);
            InsertAction.this.doRecalculate(true);
            InsertAction.this.doRevalidate(true);
            InsertAction.this.doRefresh(true);
        }

        protected int computeInsertPosition(int contextSize, boolean processPosition) throws XFormsComputeException {
            int insertPosition;
            if (this.atAttribute.equals("last()")) {
                insertPosition = contextSize;
                if (processPosition && this.positionAttribute.equals("after")) {
                    ++insertPosition;
                }
            } else {
                Double value;
                try {
                    value = XPathCache.getInstance().evaluateAsDouble(InsertAction.this.nodeset, InsertAction.this.position, "round(number(" + this.atAttribute + "))", InsertAction.this.getPrefixMapping(), InsertAction.this.xpathFunctionContext);
                }
                catch (Exception e) {
                    throw new XFormsComputeException("invalid 'at' expression at " + InsertAction.this, e, InsertAction.this.target, this.atAttribute);
                }
                double d = value;
                if (Double.isNaN(d)) {
                    insertPosition = contextSize;
                } else {
                    insertPosition = (int)d;
                    if (insertPosition < 1) {
                        insertPosition = 1;
                    } else if (insertPosition > contextSize) {
                        insertPosition = contextSize;
                    }
                }
                if (processPosition && this.positionAttribute.equals("after")) {
                    ++insertPosition;
                }
            }
            return insertPosition;
        }
    }

    private static interface IInsertAction {
        public void init() throws XFormsException;

        public String getBindingExpression();

        public void perform() throws XFormsException;
    }
}

