/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.action;

import de.betterform.xml.xforms.Initializer;
import de.betterform.xml.xforms.action.AbstractBoundAction;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.ui.Output;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageAction
extends AbstractBoundAction {
    private static final Log LOGGER = LogFactory.getLog(MessageAction.class);
    private String levelAttribute;
    private String textContent;

    public MessageAction(Element element, Model model) {
        super(element, model);
        try {
            Initializer.initializeUIElements(model, this.element, null, null);
        }
        catch (XFormsException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() throws XFormsException {
        super.init();
        this.levelAttribute = this.getXFormsAttribute("level");
        if (this.levelAttribute == null) {
            this.getLogger().warn((Object)(this + " init: required level attribute missing, assuming 'modal'"));
            this.levelAttribute = "modal";
        }
        Node child = this.element.getFirstChild();
        this.textContent = this.evaluateMessageContent();
    }

    private String evaluateMessageContent() throws XFormsException {
        String message = "";
        if (this.element.hasChildNodes()) {
            NodeList childNodes = this.element.getChildNodes();
            block4: for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                switch (node.getNodeType()) {
                    case 3: {
                        message = message + node.getTextContent();
                        continue block4;
                    }
                    case 1: {
                        Element element = (Element)node;
                        Object userData = element.getUserData("");
                        if (userData == null || !(userData instanceof Output)) continue block4;
                        Output output = (Output)userData;
                        message = message + (String)output.computeValueAttribute();
                    }
                }
            }
        }
        return message;
    }

    @Override
    public void perform() throws XFormsException {
        String bindAttribute = this.getXFormsAttribute("bind");
        String refAttribute = this.getXFormsAttribute("ref");
        String message = "";
        if (bindAttribute != null || refAttribute != null) {
            this.updateXPathContext();
            message = this.model.getInstance(this.getInstanceId()).getNodeValue(XPathUtil.getAsNode(this.nodeset, 1));
        } else {
            message = this.evaluateMessageContent();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("message", message);
        map.put("level", this.levelAttribute);
        this.container.dispatch(this.target, "betterform-render-message", map);
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

