/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.action;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.action.AbstractAction;
import de.betterform.xml.xforms.exception.XFormsBindingException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.ui.AbstractUIElement;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SetFocusAction
extends AbstractAction {
    private static Log LOGGER = LogFactory.getLog(SetFocusAction.class);
    private String referencedControl = null;

    public SetFocusAction(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void init() throws XFormsException {
        super.init();
        NodeList childNodes = this.element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!"http://www.w3.org/2002/xforms".equals(node.getNamespaceURI()) || !node.getLocalName().equals("control") || node.getNodeType() != 1) continue;
            Element elementImpl = (Element)node;
            XFormsElement xfElem = (XFormsElement)this.element.getUserData("");
            if (elementImpl.hasAttributeNS(null, "value")) {
                String xpath = elementImpl.getAttributeNS(null, "value");
                this.referencedControl = XPathCache.getInstance().evaluateAsString(xfElem.getModel().getDefaultInstance().getRootContext(), "string(" + xpath + ")");
                continue;
            }
            this.referencedControl = elementImpl.getTextContent();
        }
        if (this.referencedControl == null) {
            this.referencedControl = this.getXFormsAttribute("control");
        }
        if (this.referencedControl == null) {
            throw new XFormsBindingException("missing control attribute at " + DOMUtil.getCanonicalPath(this.getElement()), this.target, null);
        }
    }

    @Override
    public void perform() throws XFormsException {
        XFormsElement controlObject = this.container.lookup(this.referencedControl);
        if (controlObject == null || !(controlObject instanceof AbstractUIElement)) {
            throw new XFormsBindingException("invalid control id at " + DOMUtil.getCanonicalPath(this.getElement()), this.target, (Object)this.referencedControl);
        }
        this.container.dispatch(((AbstractUIElement)controlObject).getTarget(), "xforms-focus", null);
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

