/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.action;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.action.AbstractBoundAction;
import de.betterform.xml.xforms.exception.XFormsComputeException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SetValueAction
extends AbstractBoundAction {
    private static Log LOGGER = LogFactory.getLog(SetValueAction.class);
    private String nodeValue;
    private String valueAttribute;

    public SetValueAction(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void init() throws XFormsException {
        super.init();
        this.valueAttribute = this.getXFormsAttribute("value");
        if (this.valueAttribute == null) {
            Node child = this.element.getFirstChild();
            this.nodeValue = child != null && child.getNodeType() == 3 ? child.getNodeValue() : "";
        }
    }

    @Override
    public void perform() throws XFormsException {
        String value;
        this.updateXPathContext();
        if (this.valueAttribute != null) {
            try {
                value = XPathCache.getInstance().evaluateAsString(this.nodeset, this.position, this.valueAttribute, this.getPrefixMapping(), this.xpathFunctionContext);
            }
            catch (Exception e) {
                throw new XFormsComputeException("invalid value expression at: " + DOMUtil.getCanonicalPath(this.getElement()), e, this.target, this.valueAttribute);
            }
        } else {
            value = this.nodeValue;
        }
        boolean success = this.setNodeValue(value != null ? value : "");
        if (!success) {
            return;
        }
        this.doRecalculate(true);
        this.doRevalidate(true);
        this.doRefresh(true);
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

