/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.action;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.action.AbstractBoundAction;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.submission.AttributeOrValueChild;
import de.betterform.xml.xforms.ui.RepeatItem;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UnloadAction
extends AbstractBoundAction {
    private static final Log LOGGER = LogFactory.getLog(UnloadAction.class);
    private AttributeOrValueChild resource;
    private String showAttribute = null;
    private String targetAttribute = null;

    public UnloadAction(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void init() throws XFormsException {
        super.init();
        this.targetAttribute = this.getXFormsAttribute("targetid");
    }

    @Override
    public void perform() throws XFormsException {
        String evaluatedTarget = this.evalAttributeValueTemplates(this.targetAttribute, this.element);
        Element targetElem = this.getTargetElement(evaluatedTarget);
        this.destroyembeddedModels(targetElem);
        DOMUtil.removeAllChildren(targetElem);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("show", this.showAttribute);
        if (this.isRepeated()) {
            map.put("nameTarget", evaluatedTarget);
            String idForNamedElement = UnloadAction.getXFormsAttribute(this.getTargetElement(evaluatedTarget), "id");
            map.put("xlinkTarget", idForNamedElement);
        } else {
            map.put("xlinkTarget", evaluatedTarget);
        }
        this.container.dispatch(this.target, "betterform-load-uri", map);
    }

    private void destroyembeddedModels(Element targetElem) throws XFormsException {
        NodeList childNodes = targetElem.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1) continue;
            Element elementImpl = (Element)node;
            String name = elementImpl.getLocalName();
            String uri = elementImpl.getNamespaceURI();
            if ("http://www.w3.org/2002/xforms".equals(uri) && name.equals("model")) {
                Model model = (Model)elementImpl.getUserData("");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("dispatch 'model-destruct' event to embedded model: " + model.getId()));
                }
                model.dispose();
                this.container.removeModel(model);
                model = null;
                continue;
            }
            this.destroyembeddedModels(elementImpl);
        }
    }

    private Element getTargetElement(String evaluatedTarget) throws XFormsException {
        Element targetElem = null;
        if (this.isRepeated()) {
            String itemId = this.getRepeatItemId();
            RepeatItem item = (RepeatItem)this.container.lookup(itemId);
            int pos = item.getPosition();
            targetElem = (Element)XPathUtil.evaluateAsSingleNode(item.getElement().getOwnerDocument(), "//*[@name eq '" + evaluatedTarget + "']");
        } else {
            targetElem = this.container.getElementById(evaluatedTarget);
        }
        return targetElem;
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

