/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.action;

import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateHandler {
    private static Log LOGGER = LogFactory.getLog(UpdateHandler.class);
    private Model model;
    private boolean rebuild;
    private boolean recalculate;
    private boolean revalidate;
    private boolean refresh;

    public UpdateHandler(Model model) {
        this.model = model;
        this.rebuild = false;
        this.recalculate = false;
        this.revalidate = false;
        this.refresh = false;
    }

    public void doRebuild(boolean rebuild) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)((rebuild ? "deferring" : "clearing") + " rebuild"));
        }
        this.rebuild = rebuild;
    }

    public void doRecalculate(boolean recalculate) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)((recalculate ? "deferring" : "clearing") + " recalculate"));
        }
        this.recalculate = recalculate;
    }

    public void doRevalidate(boolean revalidate) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)((revalidate ? "deferring" : "clearing") + " revalidate"));
        }
        this.revalidate = revalidate;
    }

    public void doRefresh(boolean refresh) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)((refresh ? "deferring" : "clearing") + " refresh"));
        }
        this.refresh = refresh;
    }

    public void doUpdate() throws XFormsException {
        try {
            if (this.rebuild) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)"performing deferred rebuild");
                }
                this.model.getContainer().dispatch(this.model.getTarget(), "xforms-rebuild", null);
            }
            if (this.recalculate) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)"performing deferred recalculate");
                }
                this.model.getContainer().dispatch(this.model.getTarget(), "xforms-recalculate", null);
            }
            if (this.revalidate) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)"performing deferred revalidate");
                }
                this.model.getContainer().dispatch(this.model.getTarget(), "xforms-revalidate", null);
            }
            if (this.refresh) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)"performing deferred refresh");
                }
                this.model.getContainer().dispatch(this.model.getTarget(), "xforms-refresh", null);
            }
        }
        finally {
            this.rebuild = false;
            this.recalculate = false;
            this.revalidate = false;
            this.refresh = false;
        }
    }
}

