/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.exception;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.Container;
import de.betterform.xml.xforms.exception.XFormsErrorIndication;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.dom.DOMNodeWrapper;
import net.sf.saxon.dom.DocumentWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventTarget;

public class XFormsSubmitError
extends XFormsErrorIndication {
    private static final String messagePre = "xforms-submit-error: ";

    public XFormsSubmitError(String message, EventTarget target, Object info) {
        this(message, null, target, info);
    }

    public XFormsSubmitError(String message, Exception cause, EventTarget target, Object info) {
        super(messagePre + message + XFormsErrorIndication.DEVIDER + DOMUtil.getCanonicalPath((Node)((Object)target)), cause, target, info);
        this.id = "xforms-submit-error";
    }

    @Override
    public boolean isFatal() {
        return false;
    }

    public static Map<String, Object> constructInfoObject(Element submissionEl, Container container, String locationPath, String errorType, String resourceURI) {
        return XFormsSubmitError.constructInfoObject(submissionEl, container, locationPath, errorType, resourceURI, Double.NaN, null, "", "");
    }

    public static Map<String, Object> constructInfoObject(Element submissionEl, Container container, String locationPath, String errorType, String resourceURI, double responseStatusCode, Map responseHeaders, String responseReasonPhrase, String responseBody) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("location-path", locationPath);
        result.put("error-type", errorType);
        result.put("resource-uri", resourceURI);
        result.put("response-status-code", responseStatusCode);
        if (responseHeaders != null) {
            Document ownerDocument = submissionEl.getOwnerDocument();
            DocumentWrapper wrapper = container.getDocumentWrapper(submissionEl);
            ArrayList<DOMNodeWrapper> headerItems = new ArrayList<DOMNodeWrapper>(responseHeaders.size());
            for (Map.Entry entry : responseHeaders.entrySet()) {
                if ("betterform.submission.response.stream".equals(entry.getKey())) continue;
                Element headerEl = ownerDocument.createElement("header");
                Element nameEl = ownerDocument.createElement("name");
                nameEl.appendChild(ownerDocument.createTextNode((String)entry.getKey()));
                headerEl.appendChild(nameEl);
                Element valueEl = ownerDocument.createElement("value");
                valueEl.appendChild(ownerDocument.createTextNode((String)entry.getValue()));
                headerEl.appendChild(valueEl);
                headerItems.add(wrapper.wrap((Node)headerEl));
            }
            result.put("response-headers", headerItems);
        }
        result.put("response-reason-phrase", responseReasonPhrase);
        result.put("response-body", responseBody);
        return result;
    }
}

