/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.model;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.model.Instance;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.model.bind.DeclarationView;
import de.betterform.xml.xforms.model.bind.LocalUpdateView;
import de.betterform.xml.xforms.model.bind.RefreshView;
import de.betterform.xml.xforms.model.bind.StateChangeView;
import de.betterform.xml.xforms.model.bind.impl.DeclarationViewImpl;
import de.betterform.xml.xforms.model.bind.impl.LocalUpdateViewImpl;
import de.betterform.xml.xforms.model.bind.impl.RefreshViewImpl;
import de.betterform.xml.xforms.model.bind.impl.StateChangeViewImpl;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class XercesNodeImpl
implements ModelItem {
    protected static Log LOGGER = LogFactory.getLog(XercesNodeImpl.class);
    private String id;
    protected Node node;
    private ModelItem parent;
    private DeclarationViewImpl declarationView;
    private LocalUpdateViewImpl localUpdateView;
    private StateChangeViewImpl stateChangeView;
    private RefreshView refreshView;
    private String filename;
    private String mediatype;

    public XercesNodeImpl(String id) {
        this.id = id;
        this.declarationView = new DeclarationViewImpl();
        this.localUpdateView = new LocalUpdateViewImpl();
        this.stateChangeView = new StateChangeViewImpl(this);
        this.refreshView = new RefreshViewImpl(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Object getNode() {
        return this.node;
    }

    @Override
    public void setNode(Object node) {
        this.node = (Node)node;
    }

    @Override
    public ModelItem getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ModelItem parent) {
        this.parent = parent;
    }

    @Override
    public boolean isReadonly() {
        if (this.parent != null) {
            return this.localUpdateView.isLocalReadonly() || this.parent.isReadonly();
        }
        return this.localUpdateView.isLocalReadonly();
    }

    @Override
    public boolean isRequired() {
        return this.localUpdateView.isLocalRequired();
    }

    @Override
    public boolean isRelevant() {
        if (this.parent != null) {
            return this.localUpdateView.isLocalRelevant() && this.parent.isRelevant();
        }
        return this.localUpdateView.isLocalRelevant();
    }

    @Override
    public boolean isValid() {
        return this.localUpdateView.isConstraintValid() && this.localUpdateView.isDatatypeValid();
    }

    public Map<String, String> getCustomMIPValues() {
        return this.localUpdateView.getCustomMIPValues();
    }

    @Override
    public String getValue() {
        return this.node.getNodeValue();
    }

    @Override
    public boolean setValue(String value) {
        if (this.valueChanged(value)) {
            this.node.setNodeValue(value);
            return true;
        }
        return false;
    }

    @Override
    public DeclarationView getDeclarationView() {
        return this.declarationView;
    }

    @Override
    public LocalUpdateView getLocalUpdateView() {
        return this.localUpdateView;
    }

    @Override
    public StateChangeView getStateChangeView() {
        return this.stateChangeView;
    }

    @Override
    public RefreshView getRefreshView() {
        return this.refreshView;
    }

    @Override
    public boolean isXSINillable() {
        return false;
    }

    @Override
    public String getXSIType() {
        return null;
    }

    @Override
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void setMediatype(String mediatype) {
        this.mediatype = mediatype;
    }

    @Override
    public String getMediatype() {
        return this.mediatype;
    }

    protected final boolean valueChanged(String value) {
        String current = this.getValue();
        if (current == null && value == null || current != null && current.equals(value)) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(DOMUtil.getCanonicalPath(this.node) + " changed: oldvalue='" + current + "' newvalue='" + value + "'"));
        }
        this.stateChangeView.setValueChanged();
        this.refreshView.setValueChangedMarker();
        return true;
    }

    @Override
    public Model getModel() {
        Instance instance;
        if (this.node != null && (instance = this.node instanceof Document ? (Instance)((Document)this.node).getDocumentElement().getUserData("instance") : (Instance)this.node.getOwnerDocument().getDocumentElement().getUserData("instance")) != null) {
            return instance.getModel();
        }
        LOGGER.warn((Object)"Node is probably null");
        return null;
    }

    @Override
    public String toString() {
        return DOMUtil.getCanonicalPath(this.node);
    }
}

