/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.model.bind;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.events.DefaultAction;
import de.betterform.xml.events.XMLEvent;
import de.betterform.xml.xforms.Initializer;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.exception.XFormsBindingException;
import de.betterform.xml.xforms.exception.XFormsComputeException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Instance;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.model.bind.Binding;
import de.betterform.xml.xforms.model.bind.BindingUtil;
import de.betterform.xml.xforms.model.bind.ConstraintAttribute;
import de.betterform.xml.xforms.model.bind.ConstraintElement;
import de.betterform.xml.xforms.model.bind.DeclarationView;
import de.betterform.xml.xpath.XPathReferenceFinder;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;

public class Bind
extends XFormsElement
implements Binding,
DefaultAction {
    private static Log LOGGER = LogFactory.getLog(Bind.class);
    private String locationPath;
    private String instanceId;
    private String type;
    private String readonly;
    private String required;
    private String relevant;
    private String calculate;
    private String constraint;
    private List constraints = new ArrayList();
    private String p3ptype;
    private Map<String, String> customMIPs;
    private XPathReferenceFinder referenceFinder;
    private Set readonlyReferences;
    private Set requiredReferences;
    private Set relevantReferences;
    private Set calculateReferences;
    private Set constraintReferences;
    private HashMap<String, Set> customMIPReferences;
    protected List nodeset;
    private static final short TYPE = 0;
    private static final short READONLY = 1;
    private static final short REQUIRED = 2;
    private static final short RELEVANT = 3;
    private static final short CONSTRAINT = 4;
    private static final short CALCULATE = 5;
    private static final String COMBINE_NOT_SUPPORTED = null;
    private static final String COMBINE_ALL = "and";
    private static final String COMBINE_ONE = "or";
    private static final String TYPE_COMBINE = "and";
    private static final String CONSTRAINT_COMBINE = "and";
    private static final String RELEVANT_COMBINE = "and";
    private static final String REQUIRED_COMBINE = "or";
    private static final String READONLY_COMBINE = "or";

    public Bind(Element element, Model model) {
        super(element, model);
        this.getModel().addBindElement(this);
    }

    public void updateXPathContext() throws XFormsException {
        List inscopeContext = this.evalInScopeContext();
        String relativeExpr = this.getBindingExpression();
        try {
            if (relativeExpr != null) {
                if (this.nodeset == null) {
                    this.nodeset = new ArrayList();
                } else {
                    this.nodeset.clear();
                }
                for (int i = 0; i < inscopeContext.size(); ++i) {
                    this.nodeset.addAll(XPathCache.getInstance().evaluate(inscopeContext, i + 1, relativeExpr, this.getPrefixMapping(), this.xpathFunctionContext));
                }
            } else {
                this.nodeset = inscopeContext;
            }
        }
        catch (XFormsException e) {
            throw new XFormsComputeException(e.getMessage(), this.target, null);
        }
    }

    @Override
    public List getNodeset() {
        return this.nodeset;
    }

    @Override
    public int getPosition() {
        return 1;
    }

    @Override
    public String getBindingExpression() {
        if (BindingUtil.hasRef(this.element)) {
            return this.getXFormsAttribute("ref");
        }
        return this.getXFormsAttribute("nodeset");
    }

    @Override
    public String getBindingId() {
        return this.id;
    }

    @Override
    public Binding getEnclosingBinding() {
        Element parentElement = (Element)this.element.getParentNode();
        if (parentElement.getLocalName().equals("model")) {
            return null;
        }
        return (Binding)parentElement.getUserData("");
    }

    @Override
    public String getLocationPath() {
        return this.locationPath;
    }

    @Override
    public String getModelId() {
        return this.model.getId();
    }

    @Override
    public boolean hasBindingExpression() {
        return this.getBindingExpression() != null;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    public String getDatatype() {
        return this.type;
    }

    public String getReadonly() {
        return this.readonly;
    }

    public String getRequired() {
        return this.required;
    }

    public String getRelevant() {
        return this.relevant;
    }

    public String getCalculate() {
        return this.calculate;
    }

    public String getConstraint() {
        return this.constraint;
    }

    public List getConstraints() {
        return this.constraints;
    }

    public Map<String, String> getCustomMIPs() {
        return this.customMIPs;
    }

    public String getP3PType() {
        return this.p3ptype;
    }

    public void setReferenceFinder(XPathReferenceFinder referenceFinder) {
        this.referenceFinder = referenceFinder;
    }

    public Set getReadonlyReferences() {
        return this.readonlyReferences;
    }

    public Set getRequiredReferences() {
        return this.requiredReferences;
    }

    public Set getRelevantReferences() {
        return this.relevantReferences;
    }

    public Set getCalculateReferences() {
        return this.calculateReferences;
    }

    public Set getConstraintReferences() {
        return this.constraintReferences;
    }

    public Set getCustomMIPReferences(String customMIP) {
        return this.customMIPReferences.get(customMIP);
    }

    public Map<String, Set> getCustomMIPsReferences() {
        return this.customMIPReferences;
    }

    @Override
    public void performDefault(Event event) {
        if (event.getType().equals("xforms-binding-exception")) {
            this.getLogger().error((Object)(this + " binding exception: " + ((XMLEvent)event).getContextInfo()));
            return;
        }
    }

    @Override
    public void init() throws XFormsException {
        this.initializeDefaultAction();
        this.initializeBindingContext();
        this.initializeModelItems();
        Initializer.initializeBindElements(this.getModel(), this.getElement(), this.referenceFinder);
    }

    @Override
    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeDefaultAction();
    }

    protected void initializeDefaultAction() {
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-binding-exception", this);
    }

    protected void initializeBindingContext() throws XFormsException {
        this.locationPath = this.container.getBindingResolver().resolve(this);
        this.instanceId = this.model.computeInstanceId(this.locationPath);
        if (this.instanceId == null) {
            throw new XFormsBindingException("wrong instance id", this.target, (Object)this.locationPath);
        }
        this.p3ptype = this.getXFormsAttribute("p3ptype");
        try {
            this.type = this.getMIP((short)0);
            this.readonly = this.getMIP((short)1);
            if (this.readonly != null) {
                this.readonlyReferences = this.referenceFinder.getReferences(this.readonly, this.getPrefixMapping(), this.container);
            }
            this.required = this.getMIP((short)2);
            if (this.required != null) {
                this.requiredReferences = this.referenceFinder.getReferences(this.required, this.getPrefixMapping(), this.container);
            }
            this.relevant = this.getMIP((short)3);
            if (this.relevant != null) {
                this.relevantReferences = this.referenceFinder.getReferences(this.relevant, this.getPrefixMapping(), this.container);
            }
            this.calculate = this.getMIP((short)5);
            if (this.calculate != null) {
                this.calculateReferences = this.referenceFinder.getReferences(this.calculate, this.getPrefixMapping(), this.container);
            }
            this.registerConstraints();
            this.constraint = this.getMIP((short)4);
            if (this.constraint != null) {
                this.constraintReferences = this.referenceFinder.getReferences(this.constraint, this.getPrefixMapping(), this.container);
            }
            this.customMIPs = this.getCustomMIPAttributes();
            if (!this.customMIPs.isEmpty()) {
                this.customMIPReferences = new HashMap();
                for (String key : this.customMIPs.keySet()) {
                    this.customMIPReferences.put(key, this.referenceFinder.getReferences(this.customMIPs.get(key), this.getPrefixMapping(), this.container));
                }
            }
            this.updateXPathContext();
        }
        catch (XFormsComputeException e) {
            throw e;
        }
        catch (XFormsException e) {
            throw new XFormsComputeException(e.getMessage(), this.target, null);
        }
    }

    protected void initializeModelItems() throws XFormsException {
        Iterator iterator;
        Instance instance = this.getModel().getInstance(this.getInstanceId());
        List nodeset = this.getNodeset();
        if (nodeset != null && nodeset.size() > 0 && (iterator = instance.iterateModelItems(nodeset, false)) != null) {
            while (iterator.hasNext()) {
                ModelItem modelItem = (ModelItem)iterator.next();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(this + " init: model item for " + DOMUtil.getCanonicalPath((Node)modelItem.getNode())));
                }
                this.initializeModelItemProperties(modelItem);
            }
        }
    }

    protected void initializeModelItemProperties(ModelItem item) throws XFormsException {
        DeclarationView declaration = item.getDeclarationView();
        if (this.type != null) {
            if (declaration.getDatatype() != null) {
                throw new XFormsBindingException("property 'type' already present at model item", this.target, (Object)this.id);
            }
            if (!this.model.getValidator().isSupported(this.type)) {
                throw new XFormsBindingException("datatype '" + this.type + "' is not supported", this.target, (Object)this.id);
            }
            if (!this.model.getValidator().isKnown(this.type)) {
                throw new XFormsBindingException("datatype '" + this.type + "' is unknown", this.target, (Object)this.id);
            }
            declaration.setDatatype(this.type);
        }
        if (this.readonly != null) {
            if (declaration.getReadonly() != null) {
                this.readonly = declaration.getReadonly() + " " + "or" + " " + this.readonly;
            }
            this.readonlyReferences = this.referenceFinder.getReferences(this.readonly, this.getPrefixMapping(), this.container);
            declaration.setReadonly(this.readonly);
        }
        if (this.required != null) {
            if (declaration.getRequired() != null) {
                this.required = declaration.getRequired() + " " + "or" + " " + this.required;
            }
            this.requiredReferences = this.referenceFinder.getReferences(this.required, this.getPrefixMapping(), this.container);
            declaration.setRequired(this.required);
        }
        if (this.relevant != null) {
            if (declaration.getRelevant() != null) {
                this.relevant = declaration.getRelevant() + " " + "or" + " " + this.relevant;
            }
            this.relevantReferences = this.referenceFinder.getReferences(this.relevant, this.getPrefixMapping(), this.container);
            declaration.setRelevant(this.relevant);
        }
        if (this.calculate != null) {
            if (declaration.getCalculate() != null) {
                throw new XFormsBindingException("property 'calculate' already present at model item", this.target, (Object)this.id);
            }
            declaration.setCalculate(this.calculate);
        }
        if (this.constraint != null) {
            if (declaration.getConstraint() != null) {
                this.constraint = declaration.getConstraint() + " " + "and" + " " + this.constraint;
            }
            declaration.setConstraint(this.constraint);
            declaration.setConstraints(this.constraints);
        }
        if (this.p3ptype != null) {
            if (declaration.getP3PType() != null) {
                throw new XFormsBindingException("property 'p3ptype' already present at model item", this.target, (Object)this.id);
            }
            declaration.setP3PType(this.p3ptype);
        }
        this.updateXPathContext();
    }

    protected void disposeDefaultAction() {
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-binding-exception", this);
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }

    private void registerConstraints() {
        String s = this.getXFormsAttribute("constraint");
        if (s != null) {
            this.constraints.add(new ConstraintAttribute(this.element));
        }
        NodeList nl = this.element.getElementsByTagNameNS("http://betterform.sourceforge.net/xforms", "constraint");
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Element e = (Element)nl.item(i);
            String id = this.container.generateId();
            e.setAttribute("id", id);
            this.constraints.add(new ConstraintElement(e, this.model));
        }
    }

    private String getMIP(short MIPType) {
        Object s = null;
        switch (MIPType) {
            case 0: {
                return this.getValueForMip("type", null);
            }
            case 1: {
                return this.getValueForMip("readonly", "or");
            }
            case 2: {
                return this.getValueForMip("required", "or");
            }
            case 3: {
                return this.getValueForMip("relevant", "or");
            }
            case 5: {
                return this.getValueForMip("calculate", null);
            }
            case 4: {
                return this.getValueForMip("constraint", "and");
            }
        }
        return null;
    }

    private String getValueForMip(String mip, String combine) {
        int len = 0;
        NodeList nl = null;
        if (combine == null) {
            String s = this.getXFormsAttribute(mip);
            if (s != null) {
                return s;
            }
            if (LOGGER.isWarnEnabled() && this.element.getElementsByTagNameNS("http://betterform.sourceforge.net/xforms", mip).getLength() != 0) {
                LOGGER.warn((Object)("<bf:" + mip + "> is not supported. Use @" + mip + " on bind element instead"));
            }
        } else {
            StringBuffer buf = new StringBuffer("");
            String s = this.getXFormsAttribute(mip);
            if (s != null) {
                buf.append(s);
            }
            nl = this.element.getElementsByTagNameNS("http://betterform.sourceforge.net/xforms", mip);
            len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                Element e = (Element)nl.item(i);
                if (s != null) {
                    buf.append(" ").append(combine).append(" ");
                }
                buf.append(this.getMIPAttributeOrElement(e));
                if (i >= len - 1) continue;
                buf.append(" ").append(combine).append(" ");
            }
            if (buf.length() != 0) {
                return buf.toString();
            }
        }
        return null;
    }

    private String getMIPAttributeOrElement(Element e) {
        String mipValue = e.getAttribute("value");
        if (mipValue != "") {
            return mipValue;
        }
        Element valueElem = DOMUtil.findFirstChildNS(e, "http://betterform.sourceforge.net/xforms", "value");
        return DOMUtil.getElementValue(valueElem).trim();
    }
}

