/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.model.bind.impl;

import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.model.bind.StateChangeView;
import java.util.Map;

public class StateChangeViewImpl
implements StateChangeView {
    private ModelItem modelItem;
    private boolean valid;
    private boolean readonly;
    private boolean required;
    private boolean enabled;
    private boolean valueChanged;
    private Map<String, String> customMIPS;

    public StateChangeViewImpl(ModelItem modelItem) {
        this.modelItem = modelItem;
        this.valid = true;
        this.readonly = false;
        this.required = false;
        this.enabled = true;
        this.valueChanged = false;
        this.customMIPS = modelItem.getLocalUpdateView().getCustomMIPValues();
    }

    @Override
    public boolean hasValidChanged() {
        return this.valid != this.modelItem.isValid();
    }

    @Override
    public boolean hasReadonlyChanged() {
        return this.readonly != this.modelItem.isReadonly();
    }

    @Override
    public boolean hasRequiredChanged() {
        return this.required != this.modelItem.isRequired();
    }

    @Override
    public boolean hasEnabledChanged() {
        return this.enabled != this.modelItem.isRelevant();
    }

    @Override
    public boolean hasValueChanged() {
        return this.valueChanged;
    }

    @Override
    public boolean hasCustomMIPChanged(String key) {
        return this.customMIPS.get(key) != this.modelItem.getLocalUpdateView().getCustomMIPValues().get(key);
    }

    @Override
    public void reset() {
        this.valid = this.modelItem.isValid();
        this.readonly = this.modelItem.isReadonly();
        this.required = this.modelItem.isRequired();
        this.enabled = this.modelItem.isRelevant();
        this.customMIPS = this.modelItem.getLocalUpdateView().getCustomMIPValues();
        this.valueChanged = false;
    }

    public void setValueChanged() {
        this.valueChanged = true;
    }
}

