/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.model.constraints;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.model.bind.Constraint;
import de.betterform.xml.xforms.model.bind.DeclarationView;
import de.betterform.xml.xforms.model.constraints.Vertex;
import de.betterform.xml.xpath.impl.saxon.BetterFormXPathContext;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class ConstraintVertex
extends Vertex {
    private static Log LOGGER = LogFactory.getLog(ConstraintVertex.class);

    public ConstraintVertex(BetterFormXPathContext relativeContext, Node instanceNode, String xpathExpression) {
        super(relativeContext, instanceNode, xpathExpression);
    }

    @Override
    public short getVertexType() {
        return 5;
    }

    @Override
    public void compute() throws XFormsException {
        ModelItem modelItem = (ModelItem)this.instanceNode.getUserData("");
        DeclarationView declarationView = modelItem.getDeclarationView();
        boolean finalResult = true;
        String expr = null;
        boolean evaluates = true;
        ArrayList<Constraint> failed = new ArrayList<Constraint>();
        List constraints = declarationView.getConstraints();
        for (int i = 0; i < constraints.size(); ++i) {
            Constraint c = (Constraint)constraints.get(i);
            expr = c.getXPathExpr();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("computing constraint for: " + expr));
            }
            evaluates = XPathCache.getInstance().evaluateAsBoolean(this.relativeContext, "boolean(" + expr + ")");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("computed:" + evaluates));
            }
            if (evaluates) continue;
            c.setInvalid();
            failed.add(c);
        }
        if (failed.size() != 0) {
            finalResult = false;
        }
        modelItem.getLocalUpdateView().setConstraintValid(finalResult);
        if (finalResult) {
            modelItem.getRefreshView().setValidMarker();
        } else {
            modelItem.getRefreshView().setInvalidMarker();
            modelItem.getRefreshView().setInvalids(failed);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("evaluated expression '" + this.xpathExpression + "' for XPath:" + DOMUtil.getCanonicalPath((Node)modelItem.getNode()) + " with value '" + modelItem.getNode() + "' to '" + finalResult + "'"));
        }
    }

    @Override
    public String toString() {
        return super.toString() + " - constraint(" + this.xpathExpression + ")";
    }
}

