/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.model.constraints;

import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Instance;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.model.constraints.CalculateVertex;
import de.betterform.xml.xforms.model.constraints.ConstraintVertex;
import de.betterform.xml.xforms.model.constraints.CustomVertex;
import de.betterform.xml.xforms.model.constraints.ReadonlyVertex;
import de.betterform.xml.xforms.model.constraints.RelevantVertex;
import de.betterform.xml.xforms.model.constraints.RequiredVertex;
import de.betterform.xml.xforms.model.constraints.Vertex;
import de.betterform.xml.xpath.impl.saxon.BetterFormXPathContext;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class DependencyGraph {
    private static Log LOGGER = LogFactory.getLog(DependencyGraph.class);
    protected Vector vertices = new Vector();

    public Vertex getVertex(Node instanceNode, short property, String key) {
        Enumeration enumeration = this.vertices.elements();
        while (enumeration.hasMoreElements()) {
            boolean equalTypes;
            Vertex v = (Vertex)enumeration.nextElement();
            boolean equalNodes = v.instanceNode == instanceNode;
            boolean bl = equalTypes = v.getVertexType() == property;
            if (!equalNodes || !equalTypes || v.getVertexType() == 6 && !((CustomVertex)v).getPrefix().equals(key)) continue;
            return v;
        }
        return null;
    }

    public Vector getXPathRefNodes(BetterFormXPathContext relativeContext, String xpath, Set references) throws XFormsException {
        Vector<Object> refNodes = new Vector<Object>();
        Iterator pathes = references.iterator();
        while (pathes.hasNext()) {
            String refPath = pathes.next().toString();
            List resultSet = XPathCache.getInstance().evaluate(relativeContext, refPath);
            for (int i = 0; i < resultSet.size(); ++i) {
                Node node = XPathUtil.getAsNode(resultSet, i + 1);
                ModelItem modelItem = null;
                if (node != null) {
                    modelItem = (ModelItem)node.getUserData("");
                }
                if (modelItem == null && node != null) {
                    modelItem = Instance.createModelItem(node);
                }
                if (modelItem == null) continue;
                refNodes.add(modelItem.getNode());
            }
        }
        return refNodes;
    }

    public void addEdge(Vertex from, Vertex to) {
        from.addDep(to);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("addEdge: from " + from + " to " + to));
        }
    }

    public Vertex addVertex(BetterFormXPathContext relativeContext, Node instanceNode, String xpathExpression, short property, String customMIP) {
        Vertex v = this.getVertex(instanceNode, property, customMIP);
        if (v != null) {
            String s = v.toString();
            v.wasAlreadyInGraph = true;
            if (v.relativeContext == null) {
                v.relativeContext = relativeContext;
                v.xpathExpression = xpathExpression;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("addVertex: found vertex " + s + ", changed to " + v));
            }
            if (customMIP != null && LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("         : customMIP " + customMIP));
            }
            return v;
        }
        switch (property) {
            case 1: {
                v = new CalculateVertex(relativeContext, instanceNode, xpathExpression);
                break;
            }
            case 2: {
                v = new RelevantVertex(relativeContext, instanceNode, xpathExpression);
                break;
            }
            case 3: {
                v = new ReadonlyVertex(relativeContext, instanceNode, xpathExpression);
                break;
            }
            case 5: {
                v = new ConstraintVertex(relativeContext, instanceNode, xpathExpression);
                break;
            }
            case 4: {
                v = new RequiredVertex(relativeContext, instanceNode, xpathExpression);
                break;
            }
            case 6: {
                v = new CustomVertex(relativeContext, instanceNode, xpathExpression, customMIP);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("created vertex for Node " + v));
        }
        this.vertices.addElement(v);
        return v;
    }

    private void addVertex(Vertex v) {
        if (!this.vertices.contains(v)) {
            this.vertices.addElement(v);
        }
    }

    public void recalculate() throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"recalculate: starting ...");
        }
        this.removeNonZeroVertices();
        while (this.vertices.size() > 0) {
            Vertex v = (Vertex)this.vertices.firstElement();
            this.removeVertex(v);
            v.compute();
            Enumeration enumeration = v.depList.elements();
            while (enumeration.hasMoreElements()) {
                Vertex w = (Vertex)enumeration.nextElement();
                --w.inDegree;
                if (w.inDegree != 0) continue;
                this.addVertex(w);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"recalculate: finished");
        }
    }

    private void removeNonZeroVertices() {
        Vertex v;
        Vector<Vertex> nonzeros = new Vector<Vertex>();
        Enumeration enumeration = this.vertices.elements();
        while (enumeration.hasMoreElements()) {
            v = (Vertex)enumeration.nextElement();
            if (v.inDegree <= 0) continue;
            nonzeros.addElement(v);
        }
        enumeration = nonzeros.elements();
        while (enumeration.hasMoreElements()) {
            v = (Vertex)enumeration.nextElement();
            this.removeVertex(v);
        }
    }

    protected void removeVertex(Vertex v) {
        this.vertices.removeElement(v);
    }
}

