/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.model.constraints;

import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.model.constraints.ValidatorMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SubmissionValidatorMode
implements ValidatorMode {
    private static Log LOGGER = LogFactory.getLog(SubmissionValidatorMode.class);
    private boolean discontinued = false;
    private String statusText = "OK";

    public boolean isDiscontinued() {
        return this.discontinued;
    }

    public String getStatusText() {
        return this.statusText;
    }

    @Override
    public boolean performValidation(ModelItem modelItem) {
        if (!modelItem.isRelevant()) {
            return false;
        }
        if (!modelItem.getStateChangeView().hasValueChanged()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("validate: item " + modelItem.getNode() + " is unmodified: validation skipped"));
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean continueValidation(ModelItem modelItem) {
        if (!modelItem.isRelevant()) {
            return true;
        }
        boolean valid = modelItem.isValid();
        if (valid && modelItem.isRequired() && modelItem.getValue().length() == 0 && !this.containsSubElement(modelItem.getNode())) {
            valid = false;
        }
        if (!valid) {
            this.statusText = modelItem.getNode() + " is invalid or required but empty: validation stopped";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn((Object)("validate: item " + this.statusText));
            }
            this.discontinued = true;
            return false;
        }
        return true;
    }

    private boolean containsSubElement(Object object) {
        if (object instanceof Element) {
            Element e = (Element)object;
            NodeList nl = e.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n.getNodeType() != 1) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "submission";
    }
}

