/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.model.submission;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.submission.RequestHeader;
import de.betterform.xml.xforms.model.submission.RequestHeaders;
import de.betterform.xml.xforms.model.submission.ValueChild;
import de.betterform.xml.xforms.ui.BindingElement;
import de.betterform.xml.xforms.ui.UIElementState;
import de.betterform.xml.xforms.ui.state.BoundElementState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class Header
extends BindingElement {
    private static final Log LOGGER = LogFactory.getLog(Header.class);
    private String combine = "append";
    public static final String APPEND = "append";
    public static final String REPLACE = "replace";
    public static final String PREPEND = "prepend";
    private final ValueChild name = new ValueChild((Element)DOMUtil.getFirstChildByTagNameNS(this.element, "http://www.w3.org/2002/xforms", "name"), this.model);
    private List<ValueChild> values;

    public Header(Element element, Model model) {
        super(element, model);
        List headerChilds = DOMUtil.getChildElements(this.element);
        this.values = new ArrayList<ValueChild>();
        for (Element childElement : headerChilds) {
            if (!"value".equals(childElement.getLocalName())) continue;
            this.values.add(new ValueChild(childElement, this.model));
        }
    }

    @Override
    public void init() throws XFormsException {
        super.init();
        if (this.getXFormsAttribute("combine") != null) {
            this.combine = this.getXFormsAttribute("combine");
        }
        this.name.init();
        for (ValueChild value : this.values) {
            value.init();
        }
    }

    public String getName() throws XFormsException {
        return this.name.getValue();
    }

    public String getValue() throws XFormsException {
        StringBuilder result = new StringBuilder();
        Iterator<ValueChild> valueIterator = this.values.iterator();
        while (valueIterator.hasNext()) {
            result.append(valueIterator.next().getValue());
            if (!valueIterator.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    public RequestHeaders getHeaders() throws XFormsException {
        RequestHeaders requestHeaders = new RequestHeaders();
        this.updateXPathContext();
        for (int i = 0; i < this.nodeset.size(); ++i) {
            this.name.setPosition(i + 1);
            for (ValueChild value : this.values) {
                value.setPosition(i + 1);
            }
            String headerName = this.name.getValue();
            if (headerName == null || "".equals(headerName)) continue;
            RequestHeader requestHeader = requestHeaders.getRequestHeader(headerName);
            String value = this.getValue();
            if (requestHeader == null) {
                requestHeaders.addHeader(headerName, value);
                continue;
            }
            if (APPEND.equals(this.combine)) {
                requestHeader.appendValue(value);
                continue;
            }
            if (REPLACE.equals(this.combine)) {
                requestHeader.setValue(value);
                continue;
            }
            if (!PREPEND.equals(this.combine)) continue;
            requestHeader.prependValue(value);
        }
        return requestHeaders;
    }

    @Override
    public void dispose() throws XFormsException {
        super.dispose();
    }

    public String getCombine() {
        return this.combine;
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }

    @Override
    protected UIElementState createElementState() throws XFormsException {
        if (this.hasBindingExpression()) {
            this.elementState = new BoundElementState();
            return this.elementState;
        }
        return null;
    }
}

