/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.model.submission;

import de.betterform.xml.xforms.model.submission.RequestHeader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestHeaders {
    private List<RequestHeader> headers;
    private static Log LOGGER = LogFactory.getLog(RequestHeaders.class);

    public RequestHeaders() {
        this(10);
    }

    public RequestHeaders(int headerListSize) {
        this.headers = Collections.synchronizedList(new ArrayList(headerListSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeader(String name, String value) {
        List<RequestHeader> list = this.headers;
        synchronized (list) {
            this.headers.add(new RequestHeader(name, value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeader(RequestHeader header) {
        List<RequestHeader> list = this.headers;
        synchronized (list) {
            if (this.headers.contains(header)) {
                LOGGER.warn((Object)("Header " + header.getName() + " is already in list [value: '" + header.getValue() + "']"));
            }
            this.headers.add(header);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestHeader getRequestHeader(String name) {
        List<RequestHeader> list = this.headers;
        synchronized (list) {
            for (int i = 0; i < this.headers.size(); ++i) {
                RequestHeader requestHeader = this.headers.get(i);
                if (!name.equals(requestHeader.getName())) continue;
                return requestHeader;
            }
        }
        return null;
    }

    public synchronized List<RequestHeader> getAllHeaders() {
        return Collections.synchronizedList(this.headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containes(String name) {
        List<RequestHeader> list = this.headers;
        synchronized (list) {
            for (RequestHeader header : this.headers) {
                if (!header.getName().equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHeader(String name) {
        List<RequestHeader> list = this.headers;
        synchronized (list) {
            for (int i = 0; i < this.headers.size(); ++i) {
                RequestHeader header = this.headers.get(i);
                if (!header.getName().equalsIgnoreCase(name)) continue;
                this.headers.remove(header);
            }
        }
    }
}

