/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.model.submission;

import de.betterform.connector.SubmissionHandler;
import de.betterform.generator.XSLTGenerator;
import de.betterform.xml.config.Config;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.events.DefaultAction;
import de.betterform.xml.ns.NamespaceResolver;
import de.betterform.xml.xforms.Initializer;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.XFormsElementFactory;
import de.betterform.xml.xforms.action.UpdateHandler;
import de.betterform.xml.xforms.exception.XFormsBindingException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.exception.XFormsInternalSubmitException;
import de.betterform.xml.xforms.exception.XFormsLinkException;
import de.betterform.xml.xforms.exception.XFormsSubmitError;
import de.betterform.xml.xforms.model.Instance;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.bind.Bind;
import de.betterform.xml.xforms.model.constraints.RelevanceSelector;
import de.betterform.xml.xforms.model.constraints.SubmissionValidatorMode;
import de.betterform.xml.xforms.model.submission.AttributeOrValueChild;
import de.betterform.xml.xforms.model.submission.Header;
import de.betterform.xml.xforms.model.submission.RequestHeader;
import de.betterform.xml.xforms.model.submission.RequestHeaders;
import de.betterform.xml.xforms.ui.BindingElement;
import de.betterform.xml.xforms.ui.UIElementState;
import de.betterform.xml.xforms.ui.state.BoundElementState;
import de.betterform.xml.xforms.xpath.saxon.function.XPathFunctionContext;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import de.betterform.xml.xslt.impl.CachingTransformerService;
import de.betterform.xml.xslt.impl.ClasspathResourceResolver;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import net.sf.saxon.dom.DOMNodeWrapper;
import net.sf.saxon.dom.DocumentWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;

public class Submission
extends BindingElement
implements DefaultAction {
    private static Log LOGGER = LogFactory.getLog(Submission.class);
    private String action = null;
    private AttributeOrValueChild method = null;
    private String version = null;
    private Boolean indent = null;
    private String mediatype = null;
    private String encoding = null;
    private Boolean omitxmldeclaration = null;
    private Boolean standalone = null;
    private String cdatasectionelements = null;
    private String separator = null;
    private List<String> includenamespaceprefixes = null;
    private String replace = null;
    private String instance = null;
    private String targetExpr = null;
    private Boolean validate = null;
    private Boolean relevant = null;
    private AttributeOrValueChild resource = null;
    protected ArrayList<Header> submissionHeaders = new ArrayList();
    private String targetModelId;
    private String serialization;
    private static final String EMBEDNODE = "embedElement";
    private static final String DOCUMENT = "document";

    public Submission(Element element, Model model) {
        super(element, model);
    }

    @Deprecated
    public String getAction() {
        return this.action;
    }

    public String getResource() throws XFormsException {
        return this.resource.getValue();
    }

    public String getCDATASectionElements() {
        return this.cdatasectionelements;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public List<String> getIncludeNamespacePrefixes() {
        return this.includenamespaceprefixes;
    }

    public Boolean getIndent() {
        return this.indent;
    }

    public String getMediatype() {
        return this.mediatype;
    }

    public String getMethod() throws XFormsException {
        return this.method.getValue();
    }

    public Boolean getOmitXMLDeclaration() {
        return this.omitxmldeclaration;
    }

    public String getSeparator() {
        return this.separator;
    }

    public Boolean getStandalone() {
        return this.standalone;
    }

    public String getVersion() {
        return this.version;
    }

    public String getReplace() {
        return this.replace;
    }

    public String getInstance() {
        return this.instance;
    }

    public Boolean getRelevant() {
        return this.relevant;
    }

    public Boolean getValidate() {
        return this.validate;
    }

    @Override
    public String getLocationPath() {
        return this.locationPath;
    }

    public String getSerialization() {
        return this.serialization;
    }

    @Override
    public void init() throws XFormsException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)(this + " init"));
        }
        this.initializeDefaultAction();
        this.initializeInstanceNode();
        this.updateXPathContext();
        this.initializeSubmission();
        Initializer.initializeActionElements(this.model, this.element, null);
    }

    @Override
    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeDefaultAction();
    }

    @Override
    protected void initializeDefaultAction() {
        super.initializeDefaultAction();
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-submit", this);
    }

    @Override
    protected void updateChildren() throws XFormsException {
    }

    protected void initializeSubmission() throws XFormsException {
        String relevantAttribute;
        String validateAttribute;
        String includenamespaceprefixesAttribute;
        String omitxmldeclarationAttribute;
        String indentAttribute;
        String bindAttribute;
        this.locationPath = "/";
        String refAttribute = this.getXFormsAttribute("ref");
        if (refAttribute != null) {
            this.locationPath = refAttribute;
        }
        if ((bindAttribute = this.getXFormsAttribute("bind")) != null) {
            XFormsElement bindObject = this.container.lookup(bindAttribute);
            if (bindObject == null || !(bindObject instanceof Bind)) {
                throw new XFormsBindingException("invalid bind id at " + DOMUtil.getCanonicalPath(this.getElement()), this.target, (Object)bindAttribute);
            }
            this.locationPath = ((Bind)bindObject).getLocationPath();
        }
        this.instanceId = this.model.computeInstanceId(this.locationPath);
        this.method = new AttributeOrValueChild(this.element, this.model, "method");
        this.method.init();
        if (this.method == null) {
            throw new XFormsLinkException("no method specified for submission", this.target, null);
        }
        this.version = this.getXFormsAttribute("version");
        if (this.version == null) {
            this.version = "1.0";
        }
        this.indent = (indentAttribute = this.getXFormsAttribute("indent")) != null ? Boolean.valueOf(indentAttribute) : Boolean.valueOf(false);
        this.mediatype = this.getXFormsAttribute("mediatype");
        if (this.mediatype == null) {
            this.mediatype = "application/xml";
        }
        this.encoding = this.getXFormsAttribute("encoding");
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        this.omitxmldeclaration = (omitxmldeclarationAttribute = this.getXFormsAttribute("omit-xml-declaration")) != null ? Boolean.valueOf("true".equals(omitxmldeclarationAttribute) || "1".equals(omitxmldeclarationAttribute)) : Boolean.valueOf(false);
        String standaloneAttribute = this.getXFormsAttribute("standalone");
        if (standaloneAttribute != null) {
            this.standalone = Boolean.valueOf(standaloneAttribute);
        }
        this.cdatasectionelements = this.getXFormsAttribute("cdata-section-elements");
        this.separator = this.getXFormsAttribute("separator");
        if (this.separator == null) {
            this.separator = "&";
        }
        if ((includenamespaceprefixesAttribute = this.getXFormsAttribute("includenamespaceprefixes")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(includenamespaceprefixesAttribute);
            this.includenamespaceprefixes = new ArrayList<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                this.includenamespaceprefixes.add(tokenizer.nextToken());
            }
        }
        this.replace = this.getXFormsAttribute("replace");
        if (this.replace == null) {
            this.replace = "all";
        }
        this.instance = this.getXFormsAttribute("instance");
        this.targetExpr = this.getXFormsAttribute("targetref");
        if (this.targetExpr == null && this.getXFormsAttribute("target") != null) {
            this.targetExpr = this.getXFormsAttribute("target");
            LOGGER.warn((Object)"'target' Attribute is deprecated - Please use 'targetref' instead.");
        }
        if (this.targetExpr != null && this.targetExpr.startsWith("model('")) {
            this.targetModelId = this.targetExpr.substring(this.targetExpr.indexOf("'") + 1);
            this.targetModelId = this.targetModelId.substring(0, this.targetModelId.indexOf("'"));
            if (this.targetModelId != null && !this.targetModelId.equals("")) {
                this.targetExpr = this.targetExpr.replace("model('" + this.targetModelId + "')", "");
                if (this.targetExpr.equals("")) {
                    this.targetExpr = null;
                }
            }
        }
        if (this.container.getVersion().equals("1.0")) {
            this.action = this.getXFormsAttribute("action");
            if (this.action == null) {
                throw new XFormsLinkException("no action or resource specified for submission", this.target, null);
            }
        } else {
            this.initializeSubmissionOptions();
            this.resource = new AttributeOrValueChild(this.element, this.model, "resource");
            this.resource.init();
            if (!this.resource.isAvailable()) {
                this.action = this.getXFormsAttribute("action");
            }
            if (!this.resource.isAvailable() && this.action == null) {
                throw new XFormsLinkException("no action or resource specified for submission", this.target, null);
            }
            if (this.resource == null) {
                this.getLogger().warn((Object)(this.toString() + " relying on deprecated action attribute"));
            }
        }
        this.validate = true;
        this.serialization = this.getXFormsAttribute("serialization");
        if (this.serialization != null && this.serialization.equalsIgnoreCase("none")) {
            this.validate = false;
        }
        if ((validateAttribute = this.getXFormsAttribute("validate")) != null) {
            this.validate = Boolean.valueOf(validateAttribute);
        }
        this.relevant = (relevantAttribute = this.getXFormsAttribute("relevant")) != null ? Boolean.valueOf(relevantAttribute) : Boolean.TRUE;
    }

    @Override
    protected void disposeDefaultAction() {
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-submit", this);
    }

    @Override
    protected UIElementState createElementState() throws XFormsException {
        return this.hasBindingExpression() ? new BoundElementState() : null;
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }

    @Override
    public void performDefault(Event event) {
        try {
            if (event.getType().equals("xforms-submit")) {
                this.submit();
            }
        }
        catch (Exception e) {
            this.container.handleEventException(e);
            event.stopPropagation();
        }
    }

    protected void submit() throws XFormsException {
        Map response;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " submit"));
        }
        try {
            this.updateXPathContext();
        }
        catch (Exception xe) {
            LOGGER.warn((Object)("Exception occured while updating nodeset bound by submission " + DOMUtil.getCanonicalPath(this.element) + " " + xe.getMessage()));
            LOGGER.warn((Object)"Exception occured while updating nodeset bound by submission - exception will be ignored. Submission cancelled");
            return;
        }
        Instance instanceObject = this.model.getInstance(this.getInstanceId());
        String pathExpression = this.getLocationPath();
        if (!XPathUtil.existsNode(instanceObject.getInstanceNodeset(), 1, this.locationPath, this.getPrefixMapping(), this.xpathFunctionContext)) {
            throw new XFormsSubmitError("nodeset is empty at: " + DOMUtil.getCanonicalPath(this.getElement()), this.getTarget(), XFormsSubmitError.constructInfoObject(this.element, this.container, this.locationPath, "no-data", this.getResourceURI()));
        }
        this.submitValidate(instanceObject, pathExpression, this.getPrefixMapping(), this.xpathFunctionContext);
        Node instanceNode = this.submitSelectRelevant(instanceObject, pathExpression);
        try {
            this.processSubmissionOptions();
            if (this.resource != null && this.resource.isAvailable()) {
                this.action = this.getResourceURI();
            }
            Element submissionBodyEl = this.element.getOwnerDocument().createElement("submission-body");
            HashMap<String, DOMNodeWrapper> info = new HashMap<String, DOMNodeWrapper>();
            info.put("submission-body", this.container.getDocumentWrapper(this.element).wrap((Node)submissionBodyEl));
            this.container.dispatch(this.id, "xforms-submit-serialize", info);
            submissionBodyEl.normalize();
            SubmissionHandler sh = this.container.getConnectorFactory().createSubmissionHandler(this.action, this.element);
            response = submissionBodyEl.getFirstChild() == null ? sh.submit(this, instanceNode) : sh.submit(this, submissionBodyEl.getFirstChild());
        }
        catch (XFormsInternalSubmitException e) {
            Map<String, Object> info = XFormsSubmitError.constructInfoObject(this.element, this.container, this.locationPath, e.getErrorType(), this.getResourceURI(), e.getStatusCode(), null, e.getStatusText(), e.getResponseBodyAsString());
            throw new XFormsSubmitError("instance submission failed at: " + DOMUtil.getCanonicalPath(this.getElement()), e, this.getTarget(), info);
        }
        catch (Exception e) {
            String errorType = e instanceof XFormsInternalSubmitException ? ((XFormsInternalSubmitException)e).getErrorType() : "resource-error";
            Map<String, Object> info = XFormsSubmitError.constructInfoObject(this.element, this.container, this.locationPath, errorType, this.getResourceURI());
            if (e.getCause() != null && e.getCause().getMessage() != null) {
                info.put("response-reason-phrase", e.getCause().getMessage());
                if (e.getCause() instanceof XFormsInternalSubmitException) {
                    info.put("response-status-code", new Integer(((XFormsInternalSubmitException)e.getCause()).getStatusCode()).doubleValue());
                }
            }
            throw new XFormsSubmitError("instance submission failed at: " + DOMUtil.getCanonicalPath(this.getElement()), e, this.getTarget(), info);
        }
        if (this.replace.equals("all")) {
            this.submitReplaceAll(response);
            return;
        }
        if (this.replace.equals("instance")) {
            this.submitReplaceInstance(response);
            return;
        }
        if (this.replace.equals("text")) {
            this.submitReplaceText(response);
            return;
        }
        if (this.replace.equals("none")) {
            this.submitReplaceNone(response);
            return;
        }
        if (this.replace.equals("embedHTML")) {
            this.submitReplaceEmbedHTML(response);
            return;
        }
        if (this.replace.equals("embedXFormsUI")) {
            this.submitReplaceEmbedXForms(response);
            return;
        }
        if (this.replace.equals("new")) {
            this.submitReplaceNew(response);
            return;
        }
        throw new XFormsSubmitError("unknown replace mode " + this.replace, this.getTarget(), XFormsSubmitError.constructInfoObject(this.element, this.container, this.locationPath, "validation-error", this.getResourceURI()));
    }

    private String getResourceURI() throws XFormsException {
        String effectiveResource = this.resource.isAvailable() ? this.resource.getValue() : this.action;
        return this.container.getConnectorFactory().getAbsoluteURI(effectiveResource, this.element).toString();
    }

    private void initializeSubmissionOptions() throws XFormsException {
        XFormsElementFactory elementFactory = this.model.getContainer().getElementFactory();
        NodeList childNodes = this.element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Element elementImpl;
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1 || !XFormsElementFactory.isHeaderElement(elementImpl = (Element)node)) continue;
            Header submissionHeader = (Header)elementFactory.createXFormsElement(elementImpl, this.model);
            submissionHeader.init();
            if (this.submissionHeaders == null) {
                this.submissionHeaders = new ArrayList();
            }
            if (submissionHeader.getName() == null || submissionHeader.getName().equals("")) continue;
            this.submissionHeaders.add(submissionHeader);
        }
    }

    private void processSubmissionOptions() throws XFormsException {
        RequestHeader header;
        Map contextMap = this.container.getProcessor().getContext();
        RequestHeaders httpRequestHeader = null;
        httpRequestHeader = contextMap.containsKey("http-headers") ? (RequestHeaders)contextMap.get("http-headers") : new RequestHeaders();
        for (int z = 0; z < this.submissionHeaders.size(); ++z) {
            RequestHeaders requestHeaders = this.submissionHeaders.get(z).getHeaders();
            List<RequestHeader> allRequestHeaderList = requestHeaders.getAllHeaders();
            for (int i = 0; i < allRequestHeaderList.size(); ++i) {
                header = allRequestHeaderList.get(i);
                String headerName = header.getName();
                if (!httpRequestHeader.containes(headerName)) continue;
                httpRequestHeader.removeHeader(headerName);
            }
        }
        for (int i = 0; i < this.submissionHeaders.size(); ++i) {
            RequestHeaders requestHeadersTmp = this.submissionHeaders.get(i).getHeaders();
            List<RequestHeader> requestHeadersTmpList = requestHeadersTmp.getAllHeaders();
            for (int z = 0; z < requestHeadersTmpList.size(); ++z) {
                header = requestHeadersTmpList.get(z);
                httpRequestHeader.addHeader(header);
            }
        }
        contextMap.put("http-headers", httpRequestHeader);
    }

    protected boolean submitValidate(Instance instance, String path, Map prefixMapping, XPathFunctionContext xpathFunctionContext) throws XFormsException {
        SubmissionValidatorMode mode = new SubmissionValidatorMode();
        this.model.getValidator().validate(instance, instance.getInstanceNodeset(), 1, path, prefixMapping, xpathFunctionContext, mode);
        if (mode.isDiscontinued() && Boolean.TRUE.equals(this.validate)) {
            throw new XFormsSubmitError("instance validation failed: " + mode.getStatusText(), this.target, XFormsSubmitError.constructInfoObject(this.element, this.container, this.locationPath, "validation-error", this.getResourceURI()));
        }
        return !mode.isDiscontinued();
    }

    protected Node submitSelectRelevant(Instance instanceObject, String path) throws XFormsException {
        try {
            return Boolean.TRUE.equals(this.relevant) ? RelevanceSelector.selectRelevant(instanceObject, path) : XPathCache.getInstance().evaluateAsSingleNode(instanceObject.getRootContext(), path);
        }
        catch (Exception e) {
            throw new XFormsSubmitError("instance relevance selection failed", e, this.target, XFormsSubmitError.constructInfoObject(this.element, this.container, this.locationPath, "target", this.getResourceURI()));
        }
    }

    protected void submitReplaceAll(Map response) throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " submit: replacing all"));
        }
        HashMap header = new HashMap();
        header.putAll(response);
        Object body = header.remove("betterform.submission.response.stream");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("header", header);
        map.put("body", body);
        this.container.dispatch(this.target, "xforms-submit-done", this.constructEventInfo(response));
        if (header.containsKey("Location")) {
            map.clear();
            map.put("show", "replace");
            map.put("uri", response.get("Location"));
            this.container.dispatch(this.target, "betterform-load-uri", map);
            return;
        }
        if (this.getMediatype().equals("application/xhtml+xforms")) {
            map.put("redirectXForms", this.action);
            this.container.dispatch(this.target, "betterform-replace-all-xforms", map);
        } else {
            this.container.dispatch(this.target, "betterform-replace-all", map);
        }
        this.container.dispatch(this.target, "xforms-model-destruct", null);
        this.forward(response);
    }

    protected void submitReplaceInstance(Map response) throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " submit: replacing instance"));
        }
        Document responseInstance = this.getResponseAsDocument(response);
        if (this.targetModelId != null) {
            List models = this.container.getModels();
            Model targetModel = null;
            for (Model tmpmodel : models) {
                if (!tmpmodel.getId().equals(this.targetModelId)) continue;
                targetModel = tmpmodel;
            }
            this.updateInstanceAndModel(targetModel, responseInstance);
        } else {
            this.updateInstanceAndModel(this.model, responseInstance);
        }
        this.container.refresh();
        UpdateHandler updateHandler = this.model.getUpdateHandler();
        if (updateHandler != null) {
            updateHandler.doRebuild(false);
            updateHandler.doRecalculate(false);
            updateHandler.doRevalidate(false);
            updateHandler.doRefresh(false);
        }
        this.container.dispatch(this.target, "xforms-submit-done", this.constructEventInfo(response));
    }

    private Document getResponseAsDocument(Map response) throws XFormsException {
        Document responseInstance;
        try {
            if (response.containsKey("betterform.submission.response.document")) {
                responseInstance = (Document)response.get("betterform.submission.response.document");
            } else {
                InputStream responseStream = (InputStream)response.get("betterform.submission.response.stream");
                responseInstance = DOMUtil.parseInputStream(responseStream, true, false);
                responseStream.close();
            }
        }
        catch (Exception e) {
            throw new XFormsSubmitError("instance parsing failed", e, this.getTarget(), XFormsSubmitError.constructInfoObject(this.element, this.container, this.locationPath, "parse-error", this.getResourceURI(), 200.0, null, "", ""));
        }
        return responseInstance;
    }

    private void submitReplaceEmbedHTML(Map response) throws XFormsException {
        String targetid = this.getXFormsAttribute("targetid");
        String evaluatedTarget = this.evalAttributeValueTemplates(targetid, this.element);
        String resource = this.getResource();
        HashMap<String, String> eventInfo = new HashMap<String, String>();
        String error = null;
        if (evaluatedTarget == null) {
            error = "evaluatedTarget";
        } else if (resource == null) {
            error = "resource";
        }
        if (error != null && error.length() > 0) {
            eventInfo.put("error-type", "no " + error + "defined for submission resource");
            this.container.dispatch(this.target, "xforms-submit-error", eventInfo);
            return;
        }
        Document result = this.getResponseAsDocument(response);
        Node embedElement = result.getDocumentElement();
        if (resource.indexOf("#") != -1) {
            String fragmentid = resource.substring(resource.indexOf("#") + 1);
            if (fragmentid.indexOf("?") != -1) {
                fragmentid = fragmentid.substring(0, fragmentid.indexOf("?"));
            }
            embedElement = DOMUtil.getById(result, fragmentid);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            DOMUtil.prettyPrintDOM(embedElement, outputStream);
        }
        catch (TransformerException e) {
            throw new XFormsException(e);
        }
        eventInfo.put(EMBEDNODE, ((Object)outputStream).toString());
        eventInfo.put("embedTarget", evaluatedTarget);
        this.container.dispatch(this.target, "xforms-submit-done", eventInfo);
    }

    private void submitReplaceEmbedXForms(Map response) throws XFormsException {
        String targetid = this.getXFormsAttribute("targetid");
        String resource = this.getResource();
        HashMap<String, Object> eventInfo = new HashMap<String, Object>();
        String error = null;
        if (targetid == null) {
            error = "targetId";
        } else if (resource == null) {
            error = "resource";
        }
        if (error != null && error.length() > 0) {
            eventInfo.put("error-type", "no " + error + "defined for submission resource");
            this.container.dispatch(this.target, "xforms-submit-error", eventInfo);
            return;
        }
        Document result = this.getResponseAsDocument(response);
        Node embedElement = result.getDocumentElement();
        if (resource.indexOf("#") != -1) {
            String fragmentid = resource.substring(resource.indexOf("#") + 1);
            if (fragmentid.indexOf("?") != -1) {
                fragmentid = fragmentid.substring(0, fragmentid.indexOf("?"));
            }
            embedElement = DOMUtil.getById(result, fragmentid);
        }
        Element embeddedNode = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("get target element for id: " + targetid));
        }
        Element targetElem = this.container.getElementById(targetid);
        DOMResult domResult = new DOMResult();
        if (targetElem != null) {
            if (targetElem.hasChildNodes()) {
                Initializer.disposeUIElements(targetElem);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"destroyed any existing ui elements for target elem");
            }
            embeddedNode = (Element)this.container.getDocument().importNode(embedElement, true);
            NamespaceResolver.applyNamespaces(targetElem.getOwnerDocument().getDocumentElement(), embeddedNode);
            embeddedNode.setAttributeNS(null, "id", targetElem.getAttributeNS(null, "id"));
            DOMUtil.copyAttributes(targetElem, embeddedNode, null);
            targetElem.getParentNode().replaceChild(embeddedNode, targetElem);
            Initializer.initializeUIElements(this.model, embeddedNode, null, null);
            try {
                CachingTransformerService transformerService = new CachingTransformerService(new ClasspathResourceResolver("unused"));
                String path = this.getClass().getResource("/META-INF/resources/xslt/xhtml.xsl").getPath();
                transformerService.getTransformer(new URI(path));
                XSLTGenerator generator = new XSLTGenerator();
                generator.setTransformerService(transformerService);
                generator.setStylesheetURI(new URI(path));
                generator.setInput(embeddedNode);
                generator.setOutput(domResult);
                generator.generate();
            }
            catch (TransformerException e) {
                throw new XFormsException("Transformation error while executing 'Submission.submitReplaceEmbedXForms'", e);
            }
            catch (URISyntaxException e) {
                throw new XFormsException("Malformed URI throwed URISyntaxException in 'Submission.submitReplaceEmbedXForms'", e);
            }
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            DOMUtil.prettyPrintDOM(domResult.getNode(), outputStream);
        }
        catch (TransformerException e) {
            throw new XFormsException(e);
        }
        eventInfo.put(EMBEDNODE, ((Object)outputStream).toString());
        eventInfo.put("embedTarget", targetid);
        eventInfo.put("embedXForms", true);
        this.container.dispatch(this.target, "xforms-submit-done", eventInfo);
    }

    private void submitReplaceNew(Map response) throws XFormsException {
        Document result = this.getResponseAsDocument(response);
        Element embedElement = result.getDocumentElement();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            DOMUtil.prettyPrintDOM((Node)embedElement, outputStream);
        }
        catch (TransformerException e) {
            throw new XFormsException(e);
        }
        HashMap<String, String> eventInfo = new HashMap<String, String>();
        eventInfo.put(DOCUMENT, ((Object)outputStream).toString());
        this.container.dispatch(this.target, "xforms-submit-done", eventInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateInstanceAndModel(Model referedModel, Document responseInstance) throws XFormsException {
        if (this.targetExpr != null) {
            Node targetNode = this.instance == null ? XPathUtil.getAsNode(XPathCache.getInstance().evaluate(this.evalInScopeContext(), 1, this.targetExpr, this.prefixMapping, this.xpathFunctionContext), 1) : XPathUtil.getAsNode(XPathCache.getInstance().evaluate(referedModel.getInstance(this.instance).getRootContext().getNodeset(), 1, this.targetExpr, this.prefixMapping, this.xpathFunctionContext), 1);
            if (targetNode != null && targetNode.getNodeType() == 1) {
                targetNode.getParentNode().replaceChild(targetNode.getOwnerDocument().importNode(responseInstance.getDocumentElement(), true), targetNode);
            } else {
                if (targetNode == null || targetNode.getNodeType() != 2) throw new XFormsSubmitError("Invalid target", this.getTarget(), XFormsSubmitError.constructInfoObject(this.element, this.container, this.locationPath, "target-error", this.getResourceURI(), 200.0, null, "", ""));
                if (LOGGER.isDebugEnabled()) {
                    DOMUtil.prettyPrintDOM(responseInstance);
                }
                String attrValue = responseInstance.getDocumentElement().getTextContent();
                targetNode.setNodeValue(attrValue);
            }
        } else if (this.instance != null && referedModel.getInstance(this.instance) == null) {
            this.container.dispatch(referedModel.getId(), "xforms-binding-exception");
        } else if (this.instance != null) {
            referedModel.getInstance(this.instance).setInstanceDocument(responseInstance);
        } else {
            referedModel.getInstance(this.getInstanceId()).setInstanceDocument(responseInstance);
        }
        referedModel.rebuild();
        referedModel.recalculate();
        referedModel.revalidate();
    }

    protected void submitReplaceText(Map response) throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " submit: replacing text"));
        }
        Node targetNode = this.targetExpr != null ? XPathUtil.getAsNode(XPathCache.getInstance().evaluate(this.instance == null ? this.evalInScopeContext() : this.model.getInstance(this.instance).getRootContext().getNodeset(), 1, this.targetExpr, this.prefixMapping, this.xpathFunctionContext), 1) : (this.instance == null ? this.model.getInstance(this.getInstanceId()).getInstanceDocument().getDocumentElement() : this.model.getInstance(this.instance).getInstanceDocument().getDocumentElement());
        InputStream responseStream = (InputStream)response.get("betterform.submission.response.stream");
        StringBuilder text = new StringBuilder(512);
        try {
            int bytesRead;
            String contentType = (String)response.get("Content-Type");
            String encoding = "UTF-8";
            if (contentType != null) {
                String[] contTypeEntries = contentType.split(", ?");
                for (int i = 0; i < contTypeEntries.length; ++i) {
                    if (!contTypeEntries[i].startsWith("charset=")) continue;
                    encoding = contTypeEntries[i].substring(8);
                }
            }
            byte[] buffer = new byte[512];
            while ((bytesRead = responseStream.read(buffer)) > 0) {
                text.append(new String(buffer, 0, bytesRead, encoding));
            }
            responseStream.close();
        }
        catch (Exception e) {
            throw new XFormsSubmitError("instance parsing failed", e, this.getTarget(), XFormsSubmitError.constructInfoObject(this.element, this.container, this.locationPath, "parse-error", this.getResourceURI(), 200.0, null, "", ""));
        }
        if (targetNode == null) {
            throw new XFormsSubmitError("Invalid target", this.getTarget(), XFormsSubmitError.constructInfoObject(this.element, this.container, this.locationPath, "target-error", this.getResourceURI(), 200.0, null, "", ""));
        }
        if (targetNode.getNodeType() == 1) {
            while (targetNode.getFirstChild() != null) {
                targetNode.removeChild(targetNode.getFirstChild());
            }
            targetNode.appendChild(targetNode.getOwnerDocument().createTextNode(text.toString()));
        } else if (targetNode.getNodeType() == 2) {
            targetNode.setNodeValue(text.toString());
        } else {
            LOGGER.warn((Object)("Don't know how to handle targetNode '" + targetNode.getLocalName() + "', node is neither an element nor an attribute Node"));
        }
        this.model.rebuild();
        this.model.recalculate();
        this.model.revalidate();
        this.container.refresh();
        UpdateHandler updateHandler = this.model.getUpdateHandler();
        if (updateHandler != null) {
            updateHandler.doRebuild(false);
            updateHandler.doRecalculate(false);
            updateHandler.doRevalidate(false);
            updateHandler.doRefresh(false);
        }
        this.container.dispatch(this.target, "xforms-submit-done", this.constructEventInfo(response));
    }

    protected void submitReplaceNone(Map response) throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " submit: replacing none"));
        }
        this.container.dispatch(this.target, "xforms-submit-done", this.constructEventInfo(response));
    }

    private Map<String, Object> constructEventInfo(Map response) throws XFormsException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Document ownerDocument = this.element.getOwnerDocument();
        DocumentWrapper wrapper = new DocumentWrapper((Node)ownerDocument, this.container.getProcessor().getBaseURI(), this.container.getConfiguration());
        ArrayList<DOMNodeWrapper> headerItems = new ArrayList<DOMNodeWrapper>(response.size());
        for (Map.Entry entry : response.entrySet()) {
            if ("betterform.submission.response.stream".equals(entry.getKey()) || "betterform.submission.response.document".equals(entry.getKey()) || "response-status-code".equals(entry.getKey()) || "response-reason-phrase".equals(entry.getKey())) continue;
            Element headerEl = ownerDocument.createElement("header");
            Element nameEl = ownerDocument.createElement("name");
            nameEl.appendChild(ownerDocument.createTextNode((String)entry.getKey()));
            headerEl.appendChild(nameEl);
            Element valueEl = ownerDocument.createElement("value");
            valueEl.appendChild(ownerDocument.createTextNode((String)entry.getValue()));
            headerEl.appendChild(valueEl);
            headerItems.add(wrapper.wrap((Node)headerEl));
        }
        result.put("resource-uri", this.getResourceURI());
        result.put("response-status-code", response.containsKey("response-status-code") ? Double.parseDouble((String)response.get("response-status-code")) : Double.valueOf(200.0));
        result.put("response-headers", headerItems);
        result.put("response-reason-phrase", response.containsKey("response-reason-phrase") ? (String)response.get("response-reason-phrase") : "");
        return result;
    }

    public Map getSubmissionMap() {
        return (Map)this.container.getProcessor().getContext().get("betterform.submission.response");
    }

    public void forward(Map response) {
        this.container.getProcessor().getContext().put("betterform.submission.response", response);
    }

    public void redirect(String uri) {
        this.container.getProcessor().getContext().put("betterform.load.URI", uri);
    }

    private void destroyembeddedModels(Element targetElem) throws XFormsException {
        NodeList childNodes = targetElem.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1) continue;
            Element elementImpl = (Element)node;
            String name = elementImpl.getLocalName();
            String uri = elementImpl.getNamespaceURI();
            if ("http://www.w3.org/2002/xforms".equals(uri) && name.equals("model")) {
                Model model = (Model)elementImpl.getUserData("");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("dispatch 'model-destruct' event to embedded model: " + model.getId()));
                }
                String modelId = model.getId();
                model.dispose();
                this.container.removeModel(model);
                model = null;
                if (!Config.getInstance().getProperty("betterform.debug-allowed").equals("true")) continue;
                HashMap<String, String> contextInfo = new HashMap<String, String>(1);
                contextInfo.put("modelId", modelId);
                this.container.dispatch(this.target, "betterform-model-removed", contextInfo);
                continue;
            }
            this.destroyembeddedModels(elementImpl);
        }
    }
}

