/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui;

import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.ui.AbstractUIElement;
import de.betterform.xml.xforms.ui.Switch;
import de.betterform.xml.xforms.ui.state.UIElementStateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class Case
extends AbstractUIElement {
    private static Log LOGGER = LogFactory.getLog(Case.class);
    private boolean selected;
    private Element state;

    public Case(Element element, Model model) {
        super(element, model);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Switch getSwitch() {
        return (Switch)this.getParentObject();
    }

    public void select() throws XFormsException {
        this.selected = true;
        UIElementStateUtil.setStateAttribute(this.state, "selected", String.valueOf(this.selected));
        this.container.dispatch(this.target, "xforms-enabled", null);
        this.getSwitch().setSelected(this);
    }

    public void deselect() throws XFormsException {
        this.selected = false;
        UIElementStateUtil.setStateAttribute(this.state, "selected", String.valueOf(this.selected));
        this.container.dispatch(this.target, "xforms-disabled", null);
    }

    @Override
    public void init() throws XFormsException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)(this + " init"));
        }
        this.initializeCase();
        this.initializeChildren();
        this.initializeActions();
    }

    @Override
    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeCase();
        this.disposeChildren();
        this.disposeSelf();
    }

    protected final void initializeCase() {
        this.state = UIElementStateUtil.createStateElement(this.element);
        this.element.setAttributeNS(null, "caseId", this.originalId);
    }

    @Override
    protected void updateChildren() throws XFormsException {
        if (this.isSelected()) {
            super.updateChildren();
        }
    }

    protected final void disposeCase() {
        this.element.removeChild(this.state);
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

