/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui;

import de.betterform.xml.events.DefaultAction;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.ui.BindingElement;
import de.betterform.xml.xforms.ui.UIElementState;
import de.betterform.xml.xforms.ui.state.BoundElementState;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;

public class Group
extends BindingElement
implements DefaultAction {
    private static final Log LOGGER = LogFactory.getLog(Group.class);
    private boolean hasFocus = false;

    public Group(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void dispose() throws XFormsException {
        super.dispose();
    }

    @Override
    public void init() throws XFormsException {
        super.init();
        this.initializeActions();
    }

    @Override
    protected void initializeDefaultAction() {
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-binding-exception", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-previous", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-next", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-focus", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-help", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-hint", this);
    }

    @Override
    public void performDefault(Event event) {
        super.performDefault(event);
        if (this.isCancelled(event)) {
            this.getLogger().debug((Object)(this + " event " + event.getType() + " cancelled"));
            return;
        }
        if (event.getType().equals("xforms-previous")) {
            this.getLogger().warn((Object)(this + " default action for " + event.getType() + " is not implemented yet"));
            return;
        }
        if (event.getType().equals("xforms-next")) {
            this.getLogger().warn((Object)(this + " default action for " + event.getType() + " is not implemented yet"));
            return;
        }
        if (event.getType().equals("xforms-focus")) {
            String current;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Default processing for xforms-focus event: " + this.id));
            }
            if ((current = this.container.getFocussedContainerId()) != null && !current.equals(this.id)) {
                try {
                    this.container.dispatch(this.container.getFocussedContainerId(), "DOMFocusOut");
                }
                catch (XFormsException e) {
                    LOGGER.warn((Object)"silently failed DOMFocusOut");
                }
            }
            this.container.setFocussedContainerId(this.id);
            try {
                this.container.dispatch(this.getFirstFocusableControl(), "DOMFocusIn");
            }
            catch (XFormsException e) {
                LOGGER.warn((Object)"silently failed DOMFocusIn");
            }
            return;
        }
        if (event.getType().equals("DOMFocusIn")) {
            this.getLogger().warn((Object)(this + " default action for " + event.getType() + " is not implemented yet"));
        }
        if (event.getType().equals("DOMFocusOut")) {
            this.getLogger().warn((Object)(this + " default action for " + event.getType() + " is not implemented yet"));
        }
        if (event.getType().equals("xforms-help")) {
            this.getLogger().warn((Object)(this + " default action for " + event.getType() + " is not implemented yet"));
            return;
        }
        if (event.getType().equals("xforms-hint")) {
            this.getLogger().warn((Object)(this + " default action for " + event.getType() + " is not implemented yet"));
            return;
        }
    }

    private String getFirstFocusableControl() throws XFormsException {
        return XPathUtil.evaluateAsString(this.element, ".//*[bf:data/@bf:enabled eq 'true'][1]/@id");
    }

    @Override
    protected UIElementState createElementState() throws XFormsException {
        return this.hasBindingExpression() ? new BoundElementState(false, false) : null;
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

