/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.Initializer;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.bind.Binding;
import de.betterform.xml.xforms.ui.AbstractUIElement;
import de.betterform.xml.xforms.ui.Itemset;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Item
extends AbstractUIElement
implements Binding {
    private static final Log LOGGER = LogFactory.getLog(Item.class);
    private int position;
    private Itemset itemset;
    private String instanceId;
    private boolean hasCopyChild = false;

    public Item(Element element, Model model) {
        super(element, model);
    }

    @Override
    public String getInstanceId() throws XFormsException {
        if (this.instanceId == null) {
            this.instanceId = this.model.computeInstanceId(this.getLocationPath());
        }
        return this.instanceId;
    }

    @Override
    public void init() throws XFormsException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)(this + " init"));
        }
        if (this.getXFormsAttribute("selected") == null) {
            this.element.setAttributeNS(null, "selected", String.valueOf(false));
        }
        if (this.itemset != null) {
            Initializer.initializeUIElements(this.model, this.element, this.id, this.element.getOwnerDocument().getDocumentElement().getAttributeNS("http://betterform.sourceforge.net/xforms", "evalAVTs"));
            Initializer.initializeActionElements(this.model, this.element, this.id);
            Element copy = DOMUtil.findFirstChildNS(this.element, "http://www.w3.org/2002/xforms", "copy");
            if (copy != null) {
                this.hasCopyChild = true;
            }
            return;
        }
        this.initializeChildren();
        this.initializeActions();
    }

    @Override
    public List getNodeset() {
        if (this.itemset != null) {
            List repeatNodeset = this.itemset.getNodeset();
            int localPosition = this.getPosition();
            return repeatNodeset.size() >= localPosition ? Collections.singletonList(repeatNodeset.get(localPosition - 1)) : Collections.EMPTY_LIST;
        }
        return null;
    }

    @Override
    public void refresh() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " update"));
        }
        this.updateChildren();
    }

    @Override
    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeChildren();
        this.disposeSelf();
    }

    @Override
    public String getBindingExpression() {
        if (this.itemset != null) {
            return this.itemset.getBindingExpression() + "[" + this.getPosition() + "]";
        }
        return null;
    }

    @Override
    public String getBindingId() {
        if (this.itemset != null) {
            return this.itemset.getBindingId();
        }
        return null;
    }

    @Override
    public Binding getEnclosingBinding() {
        if (this.itemset != null) {
            return this.itemset.getEnclosingBinding();
        }
        return null;
    }

    @Override
    public String getLocationPath() {
        if (this.itemset != null) {
            return this.itemset.getLocationPath() + "[" + this.getPosition() + "]";
        }
        return null;
    }

    @Override
    public String getModelId() {
        if (this.itemset != null) {
            return this.itemset.getModelId();
        }
        return null;
    }

    @Override
    public boolean hasBindingExpression() {
        return this.getBindingExpression() != null;
    }

    public boolean isSelected() {
        String selectedAttribute = this.getXFormsAttribute("selected");
        return "true".equals(selectedAttribute);
    }

    public void select() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("selecting Item: " + this.id));
        }
        this.element.setAttributeNS(null, "selected", String.valueOf(true));
        if (this.itemset != null) {
            // empty if block
        }
    }

    public void deselect() {
        this.element.setAttributeNS(null, "selected", String.valueOf(false));
        if (this.itemset != null) {
            // empty if block
        }
    }

    private Element findElement(NodeList nodes, String namespace, String localName) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (!(child instanceof Element) || !child.getNamespaceURI().equals(namespace) || !child.getLocalName().equals(localName)) continue;
            return (Element)child;
        }
        return null;
    }

    public Object getValue() {
        Element copy = DOMUtil.findFirstChildNS(this.element, "http://www.w3.org/2002/xforms", "copy");
        if (copy == null) {
            Element value = DOMUtil.findFirstChildNS(this.element, "http://www.w3.org/2002/xforms", "value");
            if (value != null) {
                return DOMUtil.getTextNodeAsString(value);
            }
        } else {
            Element firstChild;
            Element betterformData = DOMUtil.findFirstChildNS(copy, "http://betterform.sourceforge.net/xforms", "data");
            if (betterformData != null && (firstChild = DOMUtil.getFirstChildElement(betterformData)) != null) {
                return firstChild;
            }
        }
        return null;
    }

    public Object getLabel() {
        Element label = DOMUtil.findFirstChildNS(this.element, "http://www.w3.org/2002/xforms", "label");
        return DOMUtil.getTextNodeAsString(label);
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public Itemset getItemset() {
        return this.itemset;
    }

    public void setItemset(Itemset itemset) {
        this.itemset = itemset;
    }

    public boolean hasCopyChild() {
        return this.hasCopyChild;
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

