/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.ui.BindingElement;
import de.betterform.xml.xforms.ui.Item;
import de.betterform.xml.xforms.ui.UIElementState;
import de.betterform.xml.xforms.ui.state.ItemsetElementState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Itemset
extends BindingElement {
    private static final Log LOGGER = LogFactory.getLog(Itemset.class);
    private Element prototype;
    private List items;

    public Itemset(Element element, Model model) {
        super(element, model);
    }

    public int getContextSize() throws XFormsException {
        if (this.hasBindingExpression()) {
            return this.nodeset.size();
        }
        return 0;
    }

    public Element getPrototype() {
        return this.prototype;
    }

    @Override
    public void init() throws XFormsException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)(this + " init"));
        }
        this.initializeDefaultAction();
        this.initializeInstanceNode();
        this.updateXPathContext();
        this.initializePrototype();
        this.initializeElementState();
        this.initializeItemset();
    }

    @Override
    public void refresh() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " update"));
        }
        this.updateXPathContext();
        this.updateItemset();
        this.updateElementState();
        this.updateChildren();
    }

    @Override
    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeDefaultAction();
        this.disposeChildren();
        this.disposeElementState();
        this.disposeItemset();
        this.disposeSelf();
    }

    @Override
    public boolean hasUIBinding() {
        return this.getXFormsAttribute("ref") != null || this.getXFormsAttribute("nodeset") != null;
    }

    protected void initializePrototype() {
        Document document = this.element.getOwnerDocument();
        this.prototype = document.createElementNS("http://www.w3.org/2002/xforms", (this.xformsPrefix != null ? this.xformsPrefix : "xf") + ":" + "item");
        this.prototype.setAttributeNS(null, "id", this.container.generateId());
        NodeList children = this.element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            this.prototype.appendChild(children.item(index).cloneNode(true));
        }
        DOMUtil.removeAllChildren(this.element);
    }

    protected void initializeItemset() throws XFormsException {
        int count = this.getContextSize();
        this.items = new ArrayList(count);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init: initializing " + count + " selector item(s)"));
        }
        for (int position = 1; position < count + 1; ++position) {
            this.items.add(this.initializeSelectorItem(position));
        }
    }

    protected void updateItemset() throws XFormsException {
        int position;
        int size;
        int count = this.nodeset.size();
        if (count < (size = this.items.size())) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " update: disposing " + (size - count) + " selector item(s)"));
            }
            for (position = size; position > count; --position) {
                this.disposeSelectorItem((Item)this.items.remove(position - 1));
            }
        }
        if (count > size) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " update: initializing " + (count - size) + " selector item(s)"));
            }
            for (position = size + 1; position <= count; ++position) {
                this.items.add(this.initializeSelectorItem(position));
            }
        }
    }

    protected void disposeItemset() {
        this.items.clear();
        this.items = null;
        this.prototype = null;
    }

    @Override
    protected UIElementState createElementState() throws XFormsException {
        return this.hasBindingExpression() ? new ItemsetElementState() : null;
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }

    private Item initializeSelectorItem(int position) throws XFormsException {
        Node before = DOMUtil.findNthChildNS(this.element, "http://www.w3.org/2002/xforms", "item", position);
        if (before == null) {
            before = DOMUtil.findFirstChildNS(this.element, "http://betterform.sourceforge.net/xforms", "data");
        }
        Element element = (Element)this.prototype.cloneNode(true);
        this.element.insertBefore(element, before);
        if (this.model.isReady()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("originalId", this.originalId != null ? this.originalId : this.id);
            map.put("prototypeId", this.prototype.getAttributeNS(null, "id"));
            this.container.dispatch(this.target, "betterform-prototype-cloned", map);
        }
        Item item = (Item)this.container.getElementFactory().createXFormsElement(element, this.model);
        item.setItemset(this);
        item.setPosition(position);
        item.setGeneratedId(this.container.generateId());
        item.registerId();
        item.init();
        if (this.model.isReady()) {
            Element itemLabel;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("originalId", this.originalId != null ? this.originalId : this.id);
            map.put("position", String.valueOf(position));
            Element itemValueCopy = (Element)DOMUtil.getFirstChildByTagNameNS(element, "http://www.w3.org/2002/xforms", "copy");
            if (itemValueCopy != null) {
                String copyValue = Itemset.getXFormsAttribute(itemValueCopy, "id");
                map.put("value", copyValue);
            }
            if ((itemLabel = (Element)DOMUtil.getFirstChildByTagNameNS(element, "http://www.w3.org/2002/xforms", "label")) != null) {
                map.put("label", itemLabel.getTextContent());
            }
            this.container.dispatch(this.target, "betterform-item-inserted", map);
        }
        return item;
    }

    private void disposeSelectorItem(Item item) throws XFormsException {
        Element element = item.getElement();
        int position = item.getPosition();
        item.dispose();
        this.element.removeChild(element);
        if (this.model.isReady()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("originalId", this.originalId != null ? this.originalId : this.id);
            map.put("position", String.valueOf(position));
            this.container.dispatch(this.target, "betterform-item-deleted", map);
        }
    }
}

