/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.ui.BindingElement;
import de.betterform.xml.xforms.ui.Output;
import de.betterform.xml.xforms.ui.UIElementState;
import de.betterform.xml.xforms.ui.Upload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class Mediatype
extends BindingElement {
    private static final Log LOGGER = LogFactory.getLog(Mediatype.class);

    public Mediatype(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void init() throws XFormsException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)(this + " init"));
        }
        this.initializeInstanceNode();
        XFormsElement xFormsElement = this.getParentObject();
        if (xFormsElement instanceof Upload) {
            ((Upload)xFormsElement).setMediatype(this);
        } else if (!(xFormsElement instanceof Output)) {
            throw new XFormsException("Parent Element at " + DOMUtil.getCanonicalPath(xFormsElement.getElement()) + " does not support mediatype");
        }
    }

    public String getValue() throws XFormsException {
        try {
            if (this.hasBindingExpression()) {
                return this.getNodeValue();
            }
        }
        catch (XFormsException e) {
            LOGGER.warn((Object)("Value for Mediatype " + this + " does not exist"));
        }
        return null;
    }

    public void setValue(String value) throws XFormsException {
        if (this.hasBindingExpression()) {
            this.setNodeValue(value);
        }
    }

    @Override
    protected UIElementState createElementState() throws XFormsException {
        return null;
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }

    public static boolean isMediaTypeValid(String mediatype) {
        if (mediatype == null || mediatype.equals("")) {
            return false;
        }
        return mediatype.startsWith("application/") || mediatype.startsWith("audio/") || mediatype.startsWith("example/") || mediatype.startsWith("image/") || mediatype.startsWith("message/") || mediatype.startsWith("model/") || mediatype.startsWith("multipart/") || mediatype.startsWith("text/") || mediatype.startsWith("video/");
    }
}

