/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui;

import de.betterform.xml.xforms.exception.XFormsComputeException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Instance;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.model.submission.AttributeOrValueChild;
import de.betterform.xml.xforms.ui.AbstractFormControl;
import de.betterform.xml.xforms.ui.Mediatype;
import de.betterform.xml.xforms.ui.UIElementState;
import de.betterform.xml.xforms.ui.state.OutputElementState;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import net.sf.saxon.trans.XPathException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class Output
extends AbstractFormControl {
    private static final Log LOGGER = LogFactory.getLog(Output.class);
    private String mediatype = null;
    private AttributeOrValueChild mediatypeHelper = null;

    public Output(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void init() throws XFormsException {
        super.init();
        this.mediatypeHelper = new AttributeOrValueChild(this.element, this.model, "mediatype");
        this.mediatypeHelper.init();
        if (this.mediatypeHelper != null) {
            this.mediatype = this.mediatypeHelper.getValue();
        }
        if (this.mediatype != null && !Mediatype.isMediaTypeValid(this.mediatype)) {
            this.model.getContainer().dispatch(this.target, "xforms-output-error", null);
        }
        if (this.hasBindingExpression()) {
            Instance instance = this.model.getInstance(this.getInstanceId());
            ModelItem item = instance.getModelItem(this.getInstanceNode());
            if (this.mediatype != null && Mediatype.isMediaTypeValid(this.mediatype) && item != null && !item.isReadonly()) {
                item.setMediatype(this.mediatype);
            }
        }
        if (this.mediatype != null) {
            this.getUIElementState().setProperty("mediatype", this.mediatype);
        }
    }

    @Override
    public void setValue(String value) {
        this.getLogger().warn((Object)(this + " set value: the value of an output control cannot be set"));
    }

    public boolean hasValueAttribute() {
        return this.getXFormsAttribute("value") != null;
    }

    public String getValueAttribute() {
        return this.getXFormsAttribute("value");
    }

    public Object computeValueAttribute() throws XFormsException {
        try {
            if (this.hasBindingExpression()) {
                return XPathUtil.getAsString(this.getNodeset(), this.getPosition());
            }
            return XPathCache.getInstance().evaluateAsString(this.getNodeset(), this.getPosition(), this.getValueAttribute(), this.getPrefixMapping(), this.xpathFunctionContext);
        }
        catch (XFormsException e) {
            if (e.getCause() instanceof XPathException && "XPDY0002".equals(((XPathException)e.getCause()).getErrorCodeLocalPart())) {
                return null;
            }
            if (e instanceof XFormsComputeException) {
                throw e;
            }
            throw new XFormsComputeException(e.getMessage(), e, this.getTarget(), this);
        }
    }

    @Override
    protected UIElementState createElementState() throws XFormsException {
        if (this.hasBindingExpression()) {
            return super.createElementState();
        }
        if (this.hasValueAttribute()) {
            return new OutputElementState();
        }
        return null;
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

