/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.exception.XFormsBindingException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.constraints.Validator;
import de.betterform.xml.xforms.ui.AbstractFormControl;
import de.betterform.xml.xforms.ui.UIElementState;
import de.betterform.xml.xforms.ui.state.RangeElementState;
import java.math.BigDecimal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class Range
extends AbstractFormControl {
    private static final Log LOGGER = LogFactory.getLog(Range.class);
    private String startValue;
    private static BigDecimal startDecimal;
    private String endValue;
    private static BigDecimal endDecimal;
    private String stepValue;
    private static BigDecimal stepDecimal;
    private BigDecimal valueDecimal;
    private String datatype = null;
    private String nsdatatype = null;

    public Range(Element element, Model model) {
        super(element, model);
    }

    @Override
    protected UIElementState createElementState() throws XFormsException {
        return this.hasBindingExpression() ? new RangeElementState() : null;
    }

    @Override
    public void setValue(String value) throws XFormsException {
        if (this.hasBindingExpression()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.trace((Object)("Range.setValue value:" + value + " datatype: " + this.datatype));
            }
            String typedValue = value;
            this.setNodeValue(typedValue);
            this.dispatchValueChangeSequence();
        }
    }

    @Override
    public void init() throws XFormsException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)(this + " init"));
        }
        this.initializeDefaultAction();
        this.initializeInstanceNode();
        this.updateXPathContext();
        this.initializeElementState();
        this.initializeRange();
        this.initializeChildren();
        this.initializeActions();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void refresh() throws XFormsException {
        block5: {
            super.refresh();
            tmpValue = (String)this.getValue();
            this.datatype = this.getDatatype();
            if (this.datatype.contains(":")) {
                this.datatype = this.datatype.substring(this.datatype.indexOf(":") + 1, this.datatype.length());
            }
            foreignValue = null;
            if ("int".equals(this.datatype) || "integer".equals(this.datatype) || "float".equals(this.datatype) || "decimal".equals(this.datatype) || "double".equals(this.datatype) || "string".equals(this.datatype)) {
                if (tmpValue == null || tmpValue.equals("")) {
                    tmpValue = "0";
                }
                foreignValue = new BigDecimal(tmpValue);
            }
            if (this.valueDecimal.compareTo(foreignValue) == 0) break block5;
            if (Range.endDecimal == null) ** GOTO lbl-1000
            if (Range.startDecimal == null) ** GOTO lbl-1000
            if (foreignValue.compareTo(Range.startDecimal) < 0 || foreignValue.compareTo(Range.endDecimal) > 0) {
                this.model.getContainer().dispatch(this.target, "xforms-out-of-range", null);
            } else lbl-1000:
            // 3 sources

            {
                this.model.getContainer().dispatch(this.target, "xforms-in-range", null);
            }
            this.valueDecimal = foreignValue;
        }
    }

    protected final void initializeRange() throws XFormsException {
        if (!this.hasBindingExpression()) {
            LOGGER.warn((Object)"Range: No binding attributes found!");
            return;
        }
        Validator validator = this.model.getValidator();
        this.nsdatatype = this.getDatatype();
        this.datatype = this.nsdatatype.contains(":") ? this.nsdatatype.substring(this.nsdatatype.indexOf(":") + 1, this.nsdatatype.length()) : this.nsdatatype;
        if (validator.isRestricted("yearMonthDuration", this.datatype) || validator.isRestricted("dayTimeDuration", this.datatype) || validator.isRestricted("date", this.datatype) || validator.isRestricted("time", this.datatype) || validator.isRestricted("dateTime", this.datatype) || validator.isRestricted("gYear", this.datatype) || validator.isRestricted("gYearMonth", this.datatype) || validator.isRestricted("gMonthDay", this.datatype) || validator.isRestricted("gDay", this.datatype) || validator.isRestricted("gMonth", this.datatype) || validator.isRestricted("int", this.datatype) || validator.isRestricted("integer", this.datatype) || validator.isRestricted("float", this.datatype) || validator.isRestricted("decimal", this.datatype) || validator.isRestricted("double", this.datatype)) {
            if ("int".equals(this.datatype) || "integer".equals(this.datatype) || "float".equals(this.datatype) || "decimal".equals(this.datatype) || "double".equals(this.datatype)) {
                this.createDecimalRange();
            }
        } else {
            throw new XFormsBindingException("datatype not supported by range control: " + this.datatype + " at " + DOMUtil.getCanonicalPath(this.getElement()), this.target, (Object)this.datatype);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createDecimalRange() throws XFormsException {
        block9: {
            block10: {
                String value = this.getInstanceValue();
                this.valueDecimal = value != null && value.length() > 0 ? new BigDecimal(value) : new BigDecimal(0.0);
                String stepAttribute = this.getXFormsAttribute("step");
                if (stepAttribute != null) {
                    stepDecimal = new BigDecimal(stepAttribute);
                } else {
                    stepDecimal = new BigDecimal(1.0);
                    this.stepValue = String.valueOf(stepDecimal);
                }
                this.getUIElementState().setProperty("step", stepDecimal.toString());
                String startAttribute = this.getXFormsAttribute("start");
                if (startAttribute != null) {
                    startDecimal = new BigDecimal(startAttribute);
                } else {
                    startDecimal = this.valueDecimal.subtract(stepDecimal.multiply(new BigDecimal(2.0)));
                    this.startValue = String.valueOf(startDecimal);
                }
                this.getUIElementState().setProperty("start", startDecimal.toString());
                String endAttribute = this.getXFormsAttribute("end");
                if (endAttribute != null) {
                    endDecimal = new BigDecimal(endAttribute);
                } else {
                    endDecimal = this.valueDecimal.add(stepDecimal.multiply(new BigDecimal(2.0)));
                    this.endValue = String.valueOf(endDecimal);
                }
                this.getUIElementState().setProperty("end", endDecimal.toString());
                if (endDecimal == null) break block9;
                if (startDecimal == null) break block9;
                if (this.valueDecimal.compareTo(startDecimal) < 0) break block10;
                if (this.valueDecimal.compareTo(endDecimal) <= 0) break block9;
            }
            this.model.getContainer().dispatch(this.target, "xforms-out-of-range", null);
            return;
        }
        this.model.getContainer().dispatch(this.target, "xforms-in-range", null);
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

