/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui;

import de.betterform.xml.xforms.Initializer;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.bind.Binding;
import de.betterform.xml.xforms.model.bind.BindingResolver;
import de.betterform.xml.xforms.ui.Group;
import de.betterform.xml.xforms.ui.Repeat;
import de.betterform.xml.xpath.XPathUtil;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RepeatItem
extends Group {
    private static final Log LOGGER = LogFactory.getLog(RepeatItem.class);
    private int contextPosition;
    private Repeat repeat;

    public RepeatItem(Element element, Model model) {
        super(element, model);
    }

    @Override
    public String getBindingExpression() {
        return this.repeat.getBindingExpression() + "[" + this.getPosition() + "]";
    }

    @Override
    public String getBindingId() {
        return this.repeat.getBindingId();
    }

    @Override
    public Binding getEnclosingBinding() {
        return this.repeat.getEnclosingBinding();
    }

    @Override
    public String getLocationPath() {
        return this.repeat.getLocationPath() + "[" + this.getPosition() + "]";
    }

    @Override
    public String getModelId() {
        return this.repeat.getModelId();
    }

    @Override
    public boolean hasBindingExpression() {
        return true;
    }

    public void setPosition(int position) throws XFormsException {
        this.position = position;
        String canonicalPath = BindingResolver.getCanonicalPath(this.element);
        this.contextPosition = Integer.parseInt(XPathUtil.getNodesetAndPredicates(canonicalPath)[1]);
    }

    public Repeat getRepeat() {
        return this.repeat;
    }

    public void setRepeat(Repeat repeat) {
        this.repeat = repeat;
    }

    public int getContextPosition() {
        return this.contextPosition;
    }

    public boolean isSelected() {
        boolean selected;
        boolean bl = selected = this.repeat.getIndex() == this.position;
        if (this.repeat.isRepeated()) {
            RepeatItem repeatItem = (RepeatItem)this.container.lookup(this.repeat.getRepeatItemId());
            selected = selected && repeatItem.isSelected();
        }
        return selected;
    }

    @Override
    protected void updateXPathContext() throws XFormsException {
    }

    protected String getRelativeExpression() {
        return "node()[" + this.getPosition() + "]";
    }

    @Override
    public List getNodeset() {
        List repeatNodeset = this.repeat.getNodeset();
        int localPosition = this.getPosition();
        return repeatNodeset.size() >= localPosition ? Collections.singletonList(repeatNodeset.get(localPosition - 1)) : Collections.EMPTY_LIST;
    }

    @Override
    public Node getInstanceNode() throws XFormsException {
        return de.betterform.xml.xpath.impl.saxon.XPathUtil.getAsNode(this.getNodeset(), 1);
    }

    @Override
    public void init() throws XFormsException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)(this + " init"));
        }
        this.initializeDefaultAction();
        this.updateXPathContext();
        this.initializeElementState();
        Initializer.initializeUIElements(this.model, this.element, this.id, this.element.getOwnerDocument().getDocumentElement().getAttributeNS("http://betterform.sourceforge.net/xforms", "evalAVTs"));
        Initializer.initializeActionElements(this.model, this.element, this.id);
    }

    @Override
    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeDefaultAction();
        this.disposeElementState();
        this.disposeChildren();
        this.disposeSelf();
        this.repeat = null;
        this.position = 0;
    }

    @Override
    public String toString() {
        return "[" + this.element.getNodeName() + "/repeatitem id='" + this.getId() + "']";
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

