/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui;

import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.ui.BindingElement;
import de.betterform.xml.xforms.ui.Case;
import de.betterform.xml.xforms.ui.UIElementState;
import de.betterform.xml.xforms.ui.state.BoundElementState;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Switch
extends BindingElement {
    private static final Log LOGGER = LogFactory.getLog(Switch.class);
    private Case selected = null;
    private boolean initAfterReady = false;

    public Switch(Element element, Model model) {
        super(element, model);
    }

    public Case getSelected() {
        return this.selected;
    }

    public void setSelected(Case selected) {
        this.selected = selected;
    }

    @Override
    public void init() throws XFormsException {
        super.init();
        this.initializeSwitch();
    }

    @Override
    public void refresh() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " update"));
        }
        this.updateElementState();
        this.updateChildren();
        this.updateSwitch();
    }

    @Override
    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeDefaultAction();
        this.disposeChildren();
        this.disposeElementState();
        this.disposeSwitch();
        this.disposeSelf();
    }

    protected final void initializeSwitch() throws XFormsException {
        Case caseElement;
        int index;
        NodeList childNodes = this.getElement().getChildNodes();
        ArrayList<Case> cases = new ArrayList<Case>(childNodes.getLength());
        int selection = -1;
        for (index = 0; index < childNodes.getLength(); ++index) {
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1 || !"http://www.w3.org/2002/xforms".equals(node.getNamespaceURI()) || !"case".equals(node.getLocalName())) continue;
            caseElement = (Case)node.getUserData("");
            cases.add(caseElement);
            String selectedAttribute = caseElement.getXFormsAttribute("selected");
            if (selection != -1 || !"true".equals(selectedAttribute)) continue;
            selection = cases.size() - 1;
        }
        if (selection == -1) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " init: choosing first case for selection by default"));
            }
            selection = 0;
        }
        for (index = 0; index < cases.size(); ++index) {
            caseElement = (Case)cases.get(index);
            if (index == selection) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)(this + " init: selecting case '" + caseElement.getId() + "'"));
                }
                caseElement.select();
                continue;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " init: deselecting case '" + caseElement.getId() + "'"));
            }
            caseElement.deselect();
        }
        this.initAfterReady = this.model.isReady();
    }

    protected final void updateSwitch() throws XFormsException {
        if (this.initAfterReady) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("selected", this.selected.getId());
            this.container.dispatch(this.target, "betterform-switch-toggled", map);
            this.initAfterReady = false;
        }
    }

    protected final void disposeSwitch() {
        this.selected = null;
    }

    @Override
    protected UIElementState createElementState() throws XFormsException {
        return this.hasBindingExpression() ? new BoundElementState(false, false) : null;
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

