/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui;

import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.ui.AbstractFormControl;
import java.text.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class Text
extends AbstractFormControl {
    private static final Log LOGGER = LogFactory.getLog(Text.class);

    public Text(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void init() throws XFormsException {
        super.init();
        String datatype = this.getDatatype();
        if (datatype != null && datatype.contains(":")) {
            datatype = datatype.substring(datatype.indexOf(":") + 1, datatype.length());
        }
        if (this.element.getLocalName().equals("secret")) {
            if ("base64Binary".equals(datatype) || "hexBinary".equals(datatype)) {
                throw new XFormsException("This control is bound to an incompatible datatype: " + this.getDatatype());
            }
        } else if (this.element.getLocalName().equals("textarea") && !this.model.getValidator().isKnown(datatype)) {
            throw new XFormsException("The type '" + datatype + "' is not supported");
        }
    }

    @Override
    public void setValue(String value) throws XFormsException {
        try {
            value = this.delocaliseValue(value);
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Could not delocalise value '" + value + "'"));
        }
        if (this.hasBindingExpression()) {
            this.setNodeValue(value.replaceAll("(\\r\\n)|(\\r)", "\n"));
            this.dispatchValueChangeSequence();
        }
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

