/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui.extensions;

import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.ui.BindingElement;
import de.betterform.xml.xforms.ui.UIElementState;
import de.betterform.xml.xforms.ui.state.BoundElementState;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class Dialog
extends BindingElement
implements EventListener {
    private static final Log LOGGER = LogFactory.getLog(Dialog.class);
    private boolean hasFocus = false;
    private boolean visible = false;

    public Dialog(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeDefaultAction();
        this.disposeChildren();
        this.disposeElementState();
        this.disposeSelf();
    }

    @Override
    public void init() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init"));
        }
        this.initializeDialog();
        this.initializeDefaultAction();
        this.initializeChildren();
    }

    @Override
    public void handleEvent(Event event) {
    }

    protected void initializeDialog() {
        this.container.getXMLEventService().registerDefaultAction(this.target, "betterform-dialog-open", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "betterform-dialog-close", this);
    }

    @Override
    public void performDefault(Event event) {
        super.performDefault(event);
        if (event.getType().equals("betterform-dialog-open")) {
            this.handleShow(event);
            return;
        }
        if (event.getType().equals("betterform-dialog-close")) {
            this.handleHide(event);
            return;
        }
    }

    private void handleShow(Event event) {
        if (!this.visible) {
            this.visible = true;
            String current = this.container.getFocussedContainerId();
            if (current != null && !current.equals(this.id)) {
                try {
                    this.container.dispatch(this.container.getFocussedContainerId(), "DOMFocusOut");
                }
                catch (XFormsException e) {
                    LOGGER.warn((Object)"silently failed DOMFocusOut");
                }
            }
            this.container.setFocussedContainerId(this.id);
            try {
                this.container.dispatch(this.getFirstFocusableControl(), "DOMFocusIn");
            }
            catch (XFormsException e) {
                LOGGER.warn((Object)"silently failed DOMFocusIn");
            }
        } else {
            LOGGER.info((Object)("Ignoring " + event.getType() + " event for: " + this.id + " Since it is already visible"));
        }
    }

    private void handleHide(Event event) {
        if (this.visible) {
            this.visible = false;
            String current = this.container.getFocussedContainerId();
            if (current.equals(this.id)) {
                try {
                    this.container.dispatch(this.container.getFocussedContainerId(), "DOMFocusOut");
                }
                catch (XFormsException e) {
                    LOGGER.warn((Object)"silently failed DOMFocusOut");
                }
            }
        } else {
            LOGGER.info((Object)("Ignoring " + event.getType() + " event for: " + this.id + " Since it is not visible"));
        }
    }

    private String getFirstFocusableControl() throws XFormsException {
        return XPathUtil.evaluateAsString(this.element, ".//*[bf:data/@bf:enabled eq 'true'][1]/@id");
    }

    @Override
    protected UIElementState createElementState() throws XFormsException {
        return this.hasBindingExpression() ? new BoundElementState(false, false) : null;
    }

    @Override
    public void refresh() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " update"));
        }
        this.updateChildren();
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

