/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui.state;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.ui.BindingElement;
import de.betterform.xml.xforms.ui.UIElementState;
import de.betterform.xml.xforms.ui.state.KnownDataType;
import de.betterform.xml.xforms.ui.state.UIElementStateUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BoundElementState
implements UIElementState {
    private boolean handleTypes;
    private boolean handleValue;
    private BindingElement owner;
    protected Element state;
    private boolean[] currentProperties;
    private Map<String, String> currentCustomProperties;
    private String currentType;
    private Object currentValue;
    private boolean dispatchValueChange;
    protected static Log LOGGER = LogFactory.getLog(BoundElementState.class);

    public BoundElementState() {
        this(true, true);
    }

    public BoundElementState(boolean handleTypes, boolean handleValue) {
        this.handleTypes = handleTypes;
        this.handleValue = handleValue;
        this.dispatchValueChange = true;
    }

    public String getType() {
        return this.currentType;
    }

    @Override
    public void setOwner(BindingElement owner) {
        this.owner = owner;
    }

    @Override
    public void init() throws XFormsException {
        this.state = UIElementStateUtil.createStateElement(this.owner.getElement());
        ModelItem modelItem = UIElementStateUtil.getModelItem(this.owner);
        if (!this.owner.getModel().isReady()) {
            boolean[] properties = UIElementStateUtil.getModelItemProperties(modelItem);
            this.setProperties(properties);
            this.currentProperties = properties;
            if (modelItem != null) {
                if (this.handleTypes) {
                    String datatype = UIElementStateUtil.getDatatype(modelItem, this.owner.getElement());
                    String p3ptype = modelItem.getDeclarationView().getP3PType();
                    UIElementStateUtil.setStateAttribute(this.state, "type", datatype);
                    UIElementStateUtil.setStateAttribute(this.state, "p3ptype", p3ptype);
                    this.currentType = datatype;
                    if (!KnownDataType.isKnownDataType(this.currentType, this.owner.getElement())) {
                        if (modelItem.getNode() instanceof Element) {
                            UIElementStateUtil.setStateAttribute(this.state, "base-type", UIElementStateUtil.getBaseType(modelItem.getModel().getSchemas(), this.currentType, ((Element)modelItem.getNode()).getNamespaceURI()));
                        } else {
                            UIElementStateUtil.setStateAttribute(this.state, "base-type", UIElementStateUtil.getBaseType(modelItem.getModel().getSchemas(), this.currentType, ((Node)modelItem.getNode()).getNamespaceURI()));
                        }
                    }
                }
                if (this.handleValue) {
                    if (modelItem.getNode() != null && modelItem.getNode() instanceof Element) {
                        this.currentValue = this.storeSubtree(modelItem);
                        Element childElement = DOMUtil.getFirstChildElement((Element)modelItem.getNode());
                        if (childElement != null) {
                            return;
                        }
                    }
                    String value = modelItem.getValue();
                    UIElementStateUtil.setStateAttribute(this.state, "schema-value", value);
                    value = UIElementStateUtil.localiseValue(this.owner, this.state, this.currentType, value);
                    DOMUtil.setElementValue(this.state, value);
                    this.currentValue = value;
                }
                this.currentCustomProperties = new HashMap<String, String>(2);
                this.currentCustomProperties.putAll(modelItem.getLocalUpdateView().getCustomMIPValues());
                if (this.currentCustomProperties != null) {
                    for (String key : this.currentCustomProperties.keySet()) {
                        UIElementStateUtil.setStateAttribute(this.state, key, this.currentCustomProperties.get(key));
                    }
                }
            }
        } else {
            modelItem = UIElementStateUtil.getModelItem(this.owner);
            if (modelItem != null) {
                this.currentType = modelItem.getDeclarationView().getDatatype();
                if (!KnownDataType.isKnownDataType(this.currentType, this.owner.getElement())) {
                    if (modelItem.getNode() instanceof Element) {
                        UIElementStateUtil.setStateAttribute(this.state, "base-type", UIElementStateUtil.getBaseType(modelItem.getModel().getSchemas(), this.currentType, ((Element)modelItem.getNode()).getNamespaceURI()));
                    } else {
                        UIElementStateUtil.setStateAttribute(this.state, "base-type", UIElementStateUtil.getBaseType(modelItem.getModel().getSchemas(), this.currentType, ((Node)modelItem.getNode()).getNamespaceURI()));
                    }
                }
            } else {
                LOGGER.debug((Object)"ModelItem = null");
            }
        }
    }

    protected Node storeSubtree(ModelItem modelItem) {
        Node n;
        Object o = modelItem.getNode();
        if (o instanceof Element && DOMUtil.getFirstChildElement((Element)o) != null && (n = (Node)modelItem.getNode()) != null) {
            Node imported = this.state.getOwnerDocument().importNode(n, true);
            return this.state.appendChild(imported);
        }
        return null;
    }

    @Override
    public void update() throws XFormsException {
        Map<String, String> customProperties;
        ModelItem modelItem = UIElementStateUtil.getModelItem(this.owner);
        boolean[] properties = UIElementStateUtil.getModelItemProperties(modelItem);
        this.setProperties(properties);
        String datatype = null;
        if (this.handleTypes) {
            datatype = modelItem != null ? UIElementStateUtil.getDatatype(modelItem, this.owner.getElement()) : null;
            String p3ptype = modelItem != null ? modelItem.getDeclarationView().getP3PType() : null;
            UIElementStateUtil.setStateAttribute(this.state, "type", datatype);
            UIElementStateUtil.setStateAttribute(this.state, "p3ptype", p3ptype);
            if (!KnownDataType.isKnownDataType(this.currentType, this.owner.getElement()) && modelItem != null && modelItem.getNode() != null && modelItem.getNode() instanceof Element) {
                UIElementStateUtil.setStateAttribute(this.state, "base-type", UIElementStateUtil.getBaseType(modelItem.getModel().getSchemas(), this.currentType, ((Element)modelItem.getNode()).getNamespaceURI()));
            }
        }
        Object value = null;
        if (this.handleValue) {
            if (modelItem != null && modelItem.getNode() instanceof Element) {
                value = this.storeSubtree(modelItem);
                Element childElement = DOMUtil.getFirstChildElement((Element)modelItem.getNode());
                if (childElement == null) {
                    value = modelItem != null ? modelItem.getValue() : null;
                    UIElementStateUtil.setStateAttribute(this.state, "schema-value", (String)value);
                    value = UIElementStateUtil.localiseValue(this.owner, this.state, this.currentType, (String)value);
                    DOMUtil.setElementValue(this.state, (String)value);
                }
            } else {
                value = modelItem != null ? modelItem.getValue() : null;
                UIElementStateUtil.setStateAttribute(this.state, "schema-value", (String)value);
                value = UIElementStateUtil.localiseValue(this.owner, this.state, this.currentType, (String)value);
                DOMUtil.setElementValue(this.state, (String)value);
            }
        }
        UIElementStateUtil.dispatchXFormsEvents(this.owner, modelItem);
        if (this.dispatchValueChange) {
            if (datatype == null) {
                datatype = this.currentType;
            }
            UIElementStateUtil.dispatchBetterFormEvents(this.owner, this.currentProperties, this.currentValue, this.currentType, properties, value, datatype);
            this.currentType = datatype;
            if (!KnownDataType.isKnownDataType(this.currentType, this.owner.getElement()) && modelItem != null && modelItem.getNode() != null) {
                if (modelItem.getNode() instanceof Element) {
                    UIElementStateUtil.setStateAttribute(this.state, "base-type", UIElementStateUtil.getBaseType(modelItem.getModel().getSchemas(), this.currentType, ((Element)modelItem.getNode()).getNamespaceURI()));
                } else {
                    UIElementStateUtil.setStateAttribute(this.state, "base-type", UIElementStateUtil.getBaseType(modelItem.getModel().getSchemas(), this.currentType, ((Node)modelItem.getNode()).getNamespaceURI()));
                }
            }
        } else {
            UIElementStateUtil.dispatchBetterFormEvents(this.owner, this.currentProperties, properties);
            this.dispatchValueChange = true;
        }
        this.currentProperties = properties;
        this.currentValue = value;
        if (modelItem != null && (customProperties = modelItem.getLocalUpdateView().getCustomMIPValues()) != null) {
            UIElementStateUtil.dispatchBetterFormCustomMIPEvents(this.owner, this.currentCustomProperties, customProperties);
            this.currentCustomProperties = new HashMap<String, String>();
            this.currentCustomProperties.putAll(customProperties);
        }
    }

    @Override
    public void dispose() throws XFormsException {
        this.state.getParentNode().removeChild(this.state);
        this.state = null;
        this.owner = null;
    }

    @Override
    public Object getValue() {
        return this.handleValue ? this.currentValue : null;
    }

    @Override
    public Object getSchemaValue() {
        return UIElementStateUtil.getStateAttribute(this.state, "schema-value");
    }

    @Override
    public void setProperty(String name, Object value) {
        if ("dispatchValueChange".equals(name)) {
            this.dispatchValueChange = Boolean.valueOf(String.valueOf(value));
        } else {
            UIElementStateUtil.setStateAttribute(this.state, name, (String)value);
        }
    }

    private void setProperties(boolean[] properties) {
        UIElementStateUtil.setStateAttribute(this.state, "valid", String.valueOf(properties[0]));
        UIElementStateUtil.setStateAttribute(this.state, "readonly", String.valueOf(properties[1]));
        UIElementStateUtil.setStateAttribute(this.state, "required", String.valueOf(properties[2]));
        UIElementStateUtil.setStateAttribute(this.state, "enabled", String.valueOf(properties[3]));
    }
}

