/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui.state;

import de.betterform.xml.config.Config;
import de.betterform.xml.dom.DOMComparator;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.ns.NamespaceResolver;
import de.betterform.xml.xforms.Container;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.model.bind.Constraint;
import de.betterform.xml.xforms.model.bind.RefreshView;
import de.betterform.xml.xforms.ui.BindingElement;
import de.betterform.xml.xforms.ui.Item;
import de.betterform.xml.xforms.ui.UIElementState;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamespaceItem;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventTarget;

public class UIElementStateUtil {
    public static final short VALID = 0;
    public static final short READONLY = 1;
    public static final short REQUIRED = 2;
    public static final short ENABLED = 3;
    private static final Log LOGGER = LogFactory.getLog(UIElementStateUtil.class);

    public static Element createStateElement(Element parent) {
        Element state = DOMUtil.findFirstChildNS(parent, "http://betterform.sourceforge.net/xforms", "data");
        if (state != null) {
            return state;
        }
        Document document = parent.getOwnerDocument();
        state = document.createElementNS("http://betterform.sourceforge.net/xforms", "bf:data");
        parent.appendChild(state);
        return state;
    }

    public static void setStateAttribute(Element element, String name, String value) {
        if (value != null) {
            element.setAttribute(name, value);
        } else {
            element.removeAttribute(name);
        }
    }

    public static boolean hasPropertyChanged(boolean[] currentProperties, boolean[] newProperties, short index) {
        return currentProperties == null && newProperties != null || currentProperties != null && newProperties == null || currentProperties != null && currentProperties[index] != newProperties[index];
    }

    public static boolean hasPropertyChanged(Map<String, String> currentCustomProperties, Map<String, String> newCustomProperties, String key) {
        boolean hasChanged = false;
        hasChanged = currentCustomProperties == null && newCustomProperties != null || currentCustomProperties != null && newCustomProperties == null ? true : currentCustomProperties != null && currentCustomProperties.containsKey(key) && currentCustomProperties.get(key) != newCustomProperties.get(key);
        return hasChanged;
    }

    public static boolean hasValueChanged(Object currentValue, Object newValue) {
        if (currentValue instanceof Element && newValue instanceof Element) {
            DOMComparator comparator = new DOMComparator();
            comparator.setIgnoreNamespaceDeclarations(true);
            return !comparator.compare((Element)currentValue, (Element)newValue);
        }
        if (newValue instanceof Element || currentValue instanceof Element) {
            return false;
        }
        return currentValue == null && newValue != null || currentValue != null && newValue == null || currentValue != null && !currentValue.equals(newValue);
    }

    public static boolean hasTypeChanged(String currentType, String newType) {
        return UIElementStateUtil.hasValueChanged(currentType, newType);
    }

    public static ModelItem getModelItem(BindingElement owner) throws XFormsException {
        if (owner.hasBindingExpression()) {
            return owner.getModel().getInstance(owner.getInstanceId()).getModelItem(owner.getInstanceNode());
        }
        return null;
    }

    public static boolean[] getModelItemProperties(ModelItem modelItem) {
        boolean[] properties = new boolean[]{true, false, false, false};
        if (modelItem != null) {
            properties[0] = modelItem.isValid();
            properties[1] = modelItem.isReadonly();
            properties[2] = modelItem.isRequired();
            properties[3] = modelItem.isRelevant();
        }
        return properties;
    }

    public static String getDefaultDatatype(Element element) {
        String prefix = NamespaceResolver.getPrefix(element, "http://www.w3.org/2001/XMLSchema");
        return prefix != null ? prefix + ":string" : "string";
    }

    public static String getDatatype(ModelItem modelItem, Element element) {
        String datatype = modelItem.getDeclarationView().getDatatype();
        if (datatype == null && (datatype = modelItem.getXSIType()) == null) {
            datatype = UIElementStateUtil.getDefaultDatatype(element);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("return datatype: " + datatype + " for " + DOMUtil.getCanonicalPath(element)));
        }
        return datatype;
    }

    public static void dispatchXFormsEvents(BindingElement bindingElement, ModelItem modelItem) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("dispatching refresh events for " + DOMUtil.getCanonicalPath(bindingElement.getElement())));
        }
        if (modelItem != null) {
            boolean[] properties = UIElementStateUtil.getModelItemProperties(modelItem);
            RefreshView refreshView = modelItem.getRefreshView();
            if (refreshView == null) {
                return;
            }
            Container container = bindingElement.getContainerObject();
            EventTarget eventTarget = bindingElement.getTarget();
            boolean somethingChanged = false;
            if (refreshView.isValueChangedMarked() || refreshView.isEnabledMarked()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(DOMUtil.getCanonicalPath(bindingElement.getElement()) + " bound to " + DOMUtil.getCanonicalPath((Node)modelItem.getNode()) + " has changed value or became relevant. Value='" + modelItem.getValue() + "'"));
                }
                container.dispatch(eventTarget, properties[3] ? "xforms-enabled" : "xforms-disabled", null);
                container.dispatch(eventTarget, "xforms-value-changed", null);
                if (properties[0]) {
                    container.dispatch(eventTarget, "xforms-valid", null);
                } else {
                    Map<String, Object> context = UIElementStateUtil.getAlertInfo(bindingElement, modelItem, refreshView);
                    container.dispatch(eventTarget, "xforms-invalid", context);
                }
                container.dispatch(eventTarget, properties[1] ? "xforms-readonly" : "xforms-readwrite", null);
                container.dispatch(eventTarget, properties[2] ? "xforms-required" : "xforms-optional", null);
                somethingChanged = true;
            } else {
                if (refreshView.isDisabledMarked()) {
                    container.dispatch(eventTarget, "xforms-disabled", null);
                    somethingChanged = true;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(DOMUtil.getCanonicalPath((Node)modelItem.getNode()) + " is now disabled"));
                    }
                }
                if (refreshView.isValidMarked()) {
                    container.dispatch(eventTarget, "xforms-valid", null);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(DOMUtil.getCanonicalPath((Node)modelItem.getNode()) + " is now valid"));
                    }
                }
                if (refreshView.isInvalidMarked()) {
                    Map<String, Object> context = UIElementStateUtil.getAlertInfo(bindingElement, modelItem, refreshView);
                    container.dispatch(eventTarget, "xforms-invalid", context);
                }
                if (refreshView.isReadonlyMarked()) {
                    container.dispatch(eventTarget, "xforms-readonly", null);
                    somethingChanged = true;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(DOMUtil.getCanonicalPath((Node)modelItem.getNode()) + " is now readonly"));
                    }
                }
                if (refreshView.isReadwriteMarked()) {
                    container.dispatch(eventTarget, "xforms-readwrite", null);
                    somethingChanged = true;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(DOMUtil.getCanonicalPath((Node)modelItem.getNode()) + " is now readwrite"));
                    }
                }
                if (refreshView.isOptionalMarked()) {
                    container.dispatch(eventTarget, "xforms-optional", null);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(DOMUtil.getCanonicalPath((Node)modelItem.getNode()) + " is now optional"));
                    }
                }
                if (refreshView.isRequiredMarked()) {
                    container.dispatch(eventTarget, "xforms-required", null);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(DOMUtil.getCanonicalPath((Node)modelItem.getNode()) + " is now required"));
                    }
                }
            }
            if (somethingChanged) {
                modelItem.getModel().addRefreshItem(refreshView);
            } else {
                refreshView.reset();
            }
        }
    }

    private static Map<String, Object> getAlertInfo(BindingElement bindingElement, ModelItem modelItem, RefreshView refreshView) {
        Element alertElem = (Element)DOMUtil.getFirstChildByTagNameNS(bindingElement.getElement(), "http://www.w3.org/2002/xforms", "alert");
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (alertElem != null) {
            if (alertElem.hasAttribute("srcBind")) {
                UIElementStateUtil.buildConstraintContextInfo(context, modelItem, refreshView);
            } else {
                String alertMsg = DOMUtil.getTextNodeAsString(alertElem);
                ArrayList<String> invalidConstraints = new ArrayList<String>(1);
                invalidConstraints.add(alertMsg);
                context.put("alerts", invalidConstraints);
            }
        }
        return context;
    }

    private static void buildConstraintContextInfo(Map context, ModelItem modelItem, RefreshView refreshView) {
        int i;
        List<Constraint> invalids = refreshView.getInvalids();
        ArrayList<String> invalidConstraints = new ArrayList<String>(10);
        for (i = 0; i < invalids.size(); ++i) {
            invalidConstraints.add(invalids.get(i).getAlert());
        }
        context.put("alerts", invalidConstraints);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(DOMUtil.getCanonicalPath((Node)modelItem.getNode()) + " is now invalid"));
            for (i = 0; i < invalids.size(); ++i) {
                LOGGER.debug((Object)("invalid constraint:" + invalids.get(i).getXPathExpr()));
            }
        }
    }

    public static void dispatchBetterFormEvents(BindingElement bindingElement, boolean[] currentProperties, boolean[] newProperties) throws XFormsException {
        UIElementStateUtil.dispatchBetterFormEvents(bindingElement, currentProperties, null, null, newProperties, null, null);
    }

    public static void dispatchBetterFormEvents(BindingElement bindingElement, String currentValue, String newValue) throws XFormsException {
        UIElementStateUtil.dispatchBetterFormEvents(bindingElement, null, currentValue, null, null, newValue, null);
    }

    public static void dispatchBetterFormEvents(BindingElement bindingElement, boolean[] currentProperties, String currentValue, boolean[] newProperties, String newValue) throws XFormsException {
        UIElementStateUtil.dispatchBetterFormEvents(bindingElement, currentProperties, currentValue, null, newProperties, newValue, null);
    }

    public static void dispatchBetterFormEvents(BindingElement bindingElement, boolean[] currentProperties, Object currentValue, String currentType, boolean[] newProperties, Object newValue, String newType) throws XFormsException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (UIElementStateUtil.hasPropertyChanged(currentProperties, newProperties, (short)0)) {
            context.put("valid", String.valueOf(newProperties[0]));
        }
        if (UIElementStateUtil.hasPropertyChanged(currentProperties, newProperties, (short)1)) {
            context.put("readonly", String.valueOf(newProperties[1]));
        }
        if (UIElementStateUtil.hasPropertyChanged(currentProperties, newProperties, (short)2)) {
            context.put("required", String.valueOf(newProperties[2]));
        }
        if (UIElementStateUtil.hasPropertyChanged(currentProperties, newProperties, (short)3)) {
            context.put("enabled", String.valueOf(newProperties[3]));
        }
        if (UIElementStateUtil.hasValueChanged(currentValue, newValue)) {
            context.put("value", newValue);
            String tmpType = newType;
            if (tmpType != null && tmpType.contains(":")) {
                tmpType = newType.substring(newType.indexOf(":") + 1, newType.length());
            }
            if (tmpType != null && (tmpType.equalsIgnoreCase("date") || tmpType.equalsIgnoreCase("dateTime"))) {
                UIElementState state = bindingElement.getUIElementState();
                context.put("schemaValue", state.getSchemaValue());
            }
        }
        if (UIElementStateUtil.hasTypeChanged(currentType, newType)) {
            context.put("type", newType);
        }
        if (!context.isEmpty()) {
            Container container = bindingElement.getContainerObject();
            EventTarget eventTarget = bindingElement.getTarget();
            if (bindingElement.getParentObject() instanceof Item) {
                container.dispatch(eventTarget, "betterform-item-changed", context);
            } else {
                container.dispatch(eventTarget, "betterform-state-changed", context);
            }
        }
    }

    public static void dispatchBetterFormCustomMIPEvents(BindingElement bindingElement, Map<String, String> currentCustomProperties, Map<String, String> newCustomProperties) throws XFormsException {
        HashSet<String> keySet = new HashSet<String>();
        if (currentCustomProperties != null) {
            keySet.addAll(currentCustomProperties.keySet());
        }
        if (newCustomProperties != null) {
            keySet.addAll(newCustomProperties.keySet());
        }
        HashMap<String, String> customMIP = new HashMap<String, String>();
        for (String key : keySet) {
            if (!UIElementStateUtil.hasPropertyChanged(currentCustomProperties, newCustomProperties, key)) continue;
            customMIP.put(key, "" + WordUtils.capitalize((String)newCustomProperties.get(key)));
        }
        if (!customMIP.isEmpty()) {
            Container container = bindingElement.getContainerObject();
            EventTarget eventTarget = bindingElement.getTarget();
            container.dispatch(eventTarget, "betterform-custom-mip-changed", customMIP);
        }
    }

    public static String localiseValue(BindingElement owner, Element state, String type, String value) throws XFormsException {
        block26: {
            if (value == null || value.equals("")) {
                return value;
            }
            String tmpType = type;
            if (tmpType != null && tmpType.contains(":")) {
                tmpType = tmpType.substring(tmpType.indexOf(":") + 1, tmpType.length());
            }
            if (Config.getInstance().getProperty("enable.l10n", "true").equals("true")) {
                Locale locale = (Locale)owner.getModel().getContainer().getProcessor().getContext().get("betterform.locale");
                if (tmpType == null) {
                    tmpType = owner.getModelItem().getDeclarationView().getDatatype();
                }
                if (tmpType == null) {
                    LOGGER.debug((Object)(DOMUtil.getCanonicalPath(owner.getInstanceNode()) + " has no type, assuming 'string'"));
                    return value;
                }
                if (tmpType.equalsIgnoreCase("float") || tmpType.equalsIgnoreCase("decimal") || tmpType.equalsIgnoreCase("double")) {
                    if (value.equals("")) {
                        return value;
                    }
                    if (value.equals("NaN")) {
                        return value;
                    }
                    try {
                        NumberFormat formatter = NumberFormat.getNumberInstance(locale);
                        if (formatter instanceof DecimalFormat) {
                            int separatorPos = value.indexOf(".");
                            if (separatorPos == -1) {
                                formatter.setMaximumFractionDigits(0);
                            } else {
                                int fractionDigitCount = value.length() - separatorPos - 1;
                                formatter.setMinimumFractionDigits(fractionDigitCount);
                            }
                            Double num = Double.parseDouble(value);
                            return formatter.format(num);
                        }
                        break block26;
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn((Object)("Value '" + value + "' is no valid " + tmpType));
                        return value;
                    }
                }
                if (tmpType.equalsIgnoreCase("date")) {
                    SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        Date d = sf.parse(value);
                        return DateFormat.getDateInstance(2, locale).format(d);
                    }
                    catch (ParseException e) {
                        LOGGER.warn((Object)("Value '" + value + "' is no valid " + tmpType));
                        return value;
                    }
                }
                if (tmpType.equalsIgnoreCase("dateTime")) {
                    String timezone = "";
                    String dateTime = null;
                    if (value.contains("GMT")) {
                        timezone = " GMT" + value.substring(value.lastIndexOf(":") - 3, value.length());
                        int devider = value.lastIndexOf(":");
                        dateTime = value.substring(0, devider) + value.substring(devider + 1, value.length());
                    } else if (value.contains("Z")) {
                        timezone = "";
                        dateTime = value.substring(0, value.indexOf("Z"));
                    } else if (value.contains("+")) {
                        timezone = value.substring(value.indexOf("+"), value.length());
                        dateTime = value.substring(0, value.indexOf("+"));
                    } else {
                        dateTime = value;
                    }
                    SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    try {
                        Date d = sf.parse(dateTime);
                        return DateFormat.getDateTimeInstance(2, 2, locale).format(d) + timezone;
                    }
                    catch (ParseException e) {
                        LOGGER.warn((Object)("Value '" + value + "' is no valid " + tmpType));
                        return value;
                    }
                }
                if (LOGGER.isTraceEnabled() && !tmpType.equals("string")) {
                    LOGGER.trace((Object)("Type " + tmpType + " cannot be localized"));
                }
            }
        }
        return value;
    }

    public static Object getStateAttribute(Element state, String attributeName) {
        if (state.hasAttribute(attributeName)) {
            return state.getAttribute(attributeName);
        }
        return null;
    }

    static String getBaseType(List schemas, String typeName, String namespace) {
        String namespacePrefix = null;
        if (typeName.contains(":")) {
            namespacePrefix = typeName.substring(0, typeName.indexOf(58));
            typeName = typeName.substring(typeName.indexOf(58) + 1, typeName.length());
        }
        if (namespace == null && namespacePrefix != null) {
            namespace = namespacePrefix;
        }
        for (int i = 0; i < schemas.size(); ++i) {
            XSModel schema = (XSModel)schemas.get(i);
            String baseType = UIElementStateUtil.getBaseType(schema, typeName, namespace);
            if ("".equals(baseType)) continue;
            return baseType;
        }
        return "";
    }

    static String getBaseType(XSModel schema, String typeName, String namespace) {
        ListIterator xsNamespaceItemList = schema.getNamespaceItems().listIterator();
        while (xsNamespaceItemList.hasNext()) {
            XSTypeDefinition xsTypeDefinition;
            String schemaNamespace = ((XSNamespaceItem)xsNamespaceItemList.next()).getSchemaNamespace();
            if (!schemaNamespace.equals(namespace) && !schemaNamespace.contains(namespace) || (xsTypeDefinition = schema.getTypeDefinition(typeName, schemaNamespace)) == null || !(xsTypeDefinition instanceof XSSimpleTypeDefinition)) continue;
            XSSimpleTypeDefinition xsSimpleTypeDefinition = (XSSimpleTypeDefinition)xsTypeDefinition;
            if (xsSimpleTypeDefinition.getVariety() == 3) {
                XSSimpleTypeDefinition xsSimpleTypeDefinition2;
                Object item;
                ListIterator itemTypeIterator = xsSimpleTypeDefinition.getMemberTypes().listIterator();
                if (!itemTypeIterator.hasNext() || !((item = itemTypeIterator.next()) instanceof XSSimpleTypeDefinition) || (xsSimpleTypeDefinition2 = (XSSimpleTypeDefinition)item).getBaseType() == null) continue;
                return xsSimpleTypeDefinition2.getBaseType().getName();
            }
            while (xsTypeDefinition.getBaseType() != null) {
                XSSimpleTypeDefinition xsSimpleTypeDefinition3;
                if (!((xsTypeDefinition = xsTypeDefinition.getBaseType()) instanceof XSSimpleTypeDefinition) || (xsSimpleTypeDefinition3 = (XSSimpleTypeDefinition)xsTypeDefinition).getVariety() != 1) continue;
                return xsSimpleTypeDefinition3.getPrimitiveType().getName();
            }
        }
        return "";
    }
}

