/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function;

import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import java.util.GregorianCalendar;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.StringValue;

public class AdjustDateTimeToTimezone
extends XFormsFunction {
    private static final long serialVersionUID = -5735803212070471603L;
    private static final int kLOCAL_TIME_OFFSET_IN_MINUTES = new GregorianCalendar().get(15) / 1000 / 60;

    public Item evaluateItem(XPathContext xpathContext) throws XPathException {
        if (this.argument.length == 0) {
            return StringValue.EMPTY_STRING;
        }
        CharSequence argAsString = this.argument[0].evaluateAsString(xpathContext);
        return this.adjust(argAsString.toString());
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String dateTime = arguments[0].head().getStringValue();
        return this.adjust(dateTime);
    }

    final StringValue adjust(String dateTime) {
        try {
            DateTimeValue argAsDateTime = (DateTimeValue)DateTimeValue.makeDateTimeValue((CharSequence)dateTime, (ConversionRules)new ConversionRules()).asAtomic();
            return new StringValue((CharSequence)argAsDateTime.adjustTimezone(kLOCAL_TIME_OFFSET_IN_MINUTES).getStringValue());
        }
        catch (XPathException e1) {
            return StringValue.EMPTY_STRING;
        }
    }
}

