/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Instance;
import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import net.sf.saxon.dom.DOMNodeWrapper;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Changed
extends XFormsFunction {
    private static final long serialVersionUID = -8152654592543207734L;
    private static Log LOGGER = LogFactory.getLog(Changed.class);

    public Item evaluateItem(XPathContext xpathContext) throws XPathException {
        Item item = this.argument[0].evaluateItem(xpathContext);
        return this.changed(xpathContext, item);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return this.changed(context, arguments[0].head());
    }

    private BooleanValue changed(XPathContext context, Item item) throws XPathException {
        if (item != null) {
            Node node = (Node)((DOMNodeWrapper)item).getUnderlyingNode();
            String xpath = DOMUtil.getCanonicalPath(node);
            String currentValue = DOMUtil.getTextNodeAsString(node);
            Instance owner = (Instance)node.getOwnerDocument().getDocumentElement().getUserData("instance");
            String initialValue = null;
            try {
                Document initial = owner.getInitialInstance();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Initial Instance: START:");
                    DOMUtil.prettyPrintDOM(initial);
                    LOGGER.debug((Object)"\nInitial Instance: STOP");
                }
                initialValue = XPathUtil.evaluateAsString(initial, xpath);
            }
            catch (XFormsException e) {
                throw new XPathException("initial Instance couldn't be fetched", (Throwable)e);
            }
            if (currentValue.equals(initialValue)) {
                return BooleanValue.FALSE;
            }
            return BooleanValue.TRUE;
        }
        LOGGER.warn((Object)("Item for " + context.toString() + " couldn't be found"));
        return BooleanValue.FALSE;
    }
}

