/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.action.AbstractAction;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.ui.AbstractUIElement;
import de.betterform.xml.xforms.ui.BindingElement;
import de.betterform.xml.xforms.ui.RepeatItem;
import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import de.betterform.xml.xforms.xpath.saxon.function.XPathFunctionContext;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Context
extends XFormsFunction {
    private static final Log LOGGER = LogFactory.getLog(XFormsFunction.class);
    private static final long serialVersionUID = -4093826587796615212L;

    public int computeSpecialProperties() {
        return 0xC30000;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public Item evaluateItem(XPathContext xpathContext) throws XPathException {
        XFormsElement element;
        XPathFunctionContext functionContext = this.getFunctionContext(xpathContext);
        XFormsElement xformsElement = functionContext.getXFormsElement();
        if (LOGGER.isDebugEnabled()) {
            DOMUtil.prettyPrintDOM(xformsElement.getElement());
        }
        int pos = 1;
        if (xformsElement instanceof BindingElement) {
            BindingElement bindingElement = (BindingElement)xformsElement;
            pos = bindingElement.getPosition();
            return (Item)bindingElement.getNodeset().get(pos - 1);
        }
        String id = null;
        if (xformsElement instanceof AbstractAction && ((AbstractAction)xformsElement).isRepeated()) {
            id = ((AbstractAction)xformsElement).getRepeatItemId();
        } else if (xformsElement instanceof AbstractUIElement && ((AbstractUIElement)xformsElement).isRepeated()) {
            id = ((AbstractUIElement)xformsElement).getRepeatItemId();
        }
        if (id != null && !id.equals("") && (element = xformsElement.getContainerObject().lookup(id)) != null && element instanceof RepeatItem) {
            RepeatItem item = (RepeatItem)element;
            pos = item.getPosition();
        }
        try {
            List items = xformsElement.evalInScopeContext();
            if (items.size() == 1) {
                return (Item)xformsElement.evalInScopeContext().get(0);
            }
            return (Item)xformsElement.evalInScopeContext().get(pos - 1);
        }
        catch (XFormsException e) {
            throw new XPathException((Throwable)e);
        }
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return this.evaluateItem(context);
    }

    public int getIntrinsicDependencies() {
        return 1;
    }
}

