/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function;

import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class DaysToDate
extends XFormsFunction {
    private static final long serialVersionUID = -166224567432883455L;

    public Item evaluateItem(XPathContext xpathContext) throws XPathException {
        NumericValue daysAsNumericValue = (NumericValue)this.argument[0].evaluateItem(xpathContext);
        return this.daysToDate(daysAsNumericValue);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return this.daysToDate((NumericValue)arguments[0].head());
    }

    private StringValue daysToDate(NumericValue days) {
        if (days.isNaN()) {
            return StringValue.EMPTY_STRING;
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTime(new Date(Math.round(days.getDoubleValue()) * 1000L * 60L * 60L * 24L));
        return new StringValue((CharSequence)new DateValue(cal, Integer.MIN_VALUE).getStringValue());
    }
}

