/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function;

import de.betterform.xml.xforms.Container;
import de.betterform.xml.xforms.XFormsConstants;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.action.XFormsAction;
import de.betterform.xml.xforms.ui.Output;
import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import de.betterform.xml.xforms.xpath.saxon.function.XPathFunctionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.StringValue;

public class Event
extends XFormsFunction {
    private static final long serialVersionUID = -4093826587796615212L;

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public SequenceIterator iterate(XPathContext xpathContext) throws XPathException {
        CharSequence event = this.argument[0].evaluateAsString(xpathContext);
        return this.current(xpathContext, event.toString());
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String event = arguments[0].head().toString();
        return SequenceTool.toLazySequence((SequenceIterator)this.current(context, event));
    }

    private SequenceIterator current(XPathContext context, String event) {
        XPathFunctionContext functionContext = this.getFunctionContext(context);
        XFormsElement xformsElement = functionContext.getXFormsElement();
        if (!(xformsElement instanceof XFormsAction) && !(xformsElement instanceof Output)) {
            return SingletonIterator.makeIterator((Item)StringValue.EMPTY_STRING);
        }
        Container.EventInfo infoObject = xformsElement.getContainerObject().getCurrentEventInfo();
        if (infoObject instanceof Container.EventInfo) {
            Container.EventInfo eventInfo = infoObject;
            if ("type".equals(event)) {
                return SingletonIterator.makeIterator((Item)new StringValue((CharSequence)eventInfo.getEventType()));
            }
            if ("bubbles".equals(event)) {
                return SingletonIterator.makeIterator((Item)BooleanValue.get((boolean)eventInfo.bubbles()));
            }
            if ("cancelable".equals(event)) {
                return SingletonIterator.makeIterator((Item)BooleanValue.get((boolean)eventInfo.isCancelable()));
            }
            if ("xforms-insert".equals(eventInfo.getEventType())) {
                if ("inserted-nodes".equals(event) && ((Map)eventInfo.getInfo()).containsKey("inserted-nodes")) {
                    List insertedNodes = (List)((Map)eventInfo.getInfo()).get("inserted-nodes");
                    return new ArrayIterator(new ArrayList(insertedNodes).toArray(new Item[insertedNodes.size()]));
                }
                if ("origin-nodes".equals(event) && ((Map)eventInfo.getInfo()).containsKey("origin-nodes")) {
                    List originNodes = (List)((Map)eventInfo.getInfo()).get("origin-nodes");
                    return new ArrayIterator(new ArrayList(originNodes).toArray(new Item[originNodes.size()]));
                }
                if ("insert-location-node".equals(event) && ((Map)eventInfo.getInfo()).containsKey("insert-location-node")) {
                    return SingletonIterator.makeIterator((Item)((Item)((Map)eventInfo.getInfo()).get("insert-location-node")));
                }
                if ("position".equals(event) && ((Map)eventInfo.getInfo()).containsKey("position")) {
                    return SingletonIterator.makeIterator((Item)new StringValue((CharSequence)((String)((Map)eventInfo.getInfo()).get("position"))));
                }
            } else if ("xforms-delete".equals(eventInfo.getEventType())) {
                if ("delete-location".equals(event) && ((Map)eventInfo.getInfo()).containsKey("delete-location")) {
                    return SingletonIterator.makeIterator((Item)new DoubleValue(((Double)((Map)eventInfo.getInfo()).get("delete-location")).doubleValue()));
                }
                if ("deleted-nodes".equals(event) && ((Map)eventInfo.getInfo()).containsKey("deleted-nodes")) {
                    List deleteNodes = (List)((Map)eventInfo.getInfo()).get("deleted-nodes");
                    return new ArrayIterator(new ArrayList(deleteNodes).toArray(new Item[deleteNodes.size()]));
                }
            } else if ("xforms-submit-error".equals(eventInfo.getEventType())) {
                if ("error-type".equals(event) && ((Map)eventInfo.getInfo()).containsKey("error-type")) {
                    return SingletonIterator.makeIterator((Item)new StringValue((CharSequence)((String)((Map)eventInfo.getInfo()).get("error-type"))));
                }
                if ("resource-uri".equals(event) && ((Map)eventInfo.getInfo()).containsKey("resource-uri")) {
                    return SingletonIterator.makeIterator((Item)new StringValue((CharSequence)((String)((Map)eventInfo.getInfo()).get("resource-uri"))));
                }
                if ("response-status-code".equals(event) && ((Map)eventInfo.getInfo()).containsKey("response-status-code")) {
                    return SingletonIterator.makeIterator((Item)new DoubleValue(((Double)((Map)eventInfo.getInfo()).get("response-status-code")).doubleValue()));
                }
                if ("response-headers".equals(event) && ((Map)eventInfo.getInfo()).containsKey("response-headers")) {
                    ArrayList headers = (ArrayList)((Map)eventInfo.getInfo()).get("response-headers");
                    Item[] headersAsArray = new Item[headers.size()];
                    return new ArrayIterator(headers.toArray(headersAsArray));
                }
                if ("response-reason-phrase".equals(event) && ((Map)eventInfo.getInfo()).containsKey("response-reason-phrase")) {
                    return SingletonIterator.makeIterator((Item)new StringValue((CharSequence)((String)((Map)eventInfo.getInfo()).get("response-reason-phrase"))));
                }
                if ("response-body".equals(event) && ((Map)eventInfo.getInfo()).containsKey("response-body")) {
                    return SingletonIterator.makeIterator((Item)new StringValue((CharSequence)((String)((Map)eventInfo.getInfo()).get("response-body"))));
                }
            } else if ("xforms-submit-done".equals(eventInfo.getEventType())) {
                if ("resource-uri".equals(event) && ((Map)eventInfo.getInfo()).containsKey("resource-uri")) {
                    return SingletonIterator.makeIterator((Item)new StringValue((CharSequence)((String)((Map)eventInfo.getInfo()).get("resource-uri"))));
                }
                if ("response-status-code".equals(event) && ((Map)eventInfo.getInfo()).containsKey("response-status-code")) {
                    return SingletonIterator.makeIterator((Item)new DoubleValue(((Double)((Map)eventInfo.getInfo()).get("response-status-code")).doubleValue()));
                }
                if ("response-headers".equals(event) && ((Map)eventInfo.getInfo()).containsKey("response-headers")) {
                    ArrayList headers = (ArrayList)((Map)eventInfo.getInfo()).get("response-headers");
                    Item[] headersAsArray = new Item[headers.size()];
                    return new ArrayIterator(headers.toArray(headersAsArray));
                }
                if ("response-reason-phrase".equals(event) && ((Map)eventInfo.getInfo()).containsKey("response-reason-phrase")) {
                    return SingletonIterator.makeIterator((Item)new StringValue((CharSequence)((String)((Map)eventInfo.getInfo()).get("response-reason-phrase"))));
                }
            } else if ("xforms-submit-serialize".equals(eventInfo.getEventType())) {
                if ("submission-body".equals(event) && ((Map)eventInfo.getInfo()).containsKey("submission-body")) {
                    return SingletonIterator.makeIterator((Item)((Item)((Map)eventInfo.getInfo()).get("submission-body")));
                }
                if ("response-reason-phrase".equals(event) && ((Map)eventInfo.getInfo()).containsKey("response-reason-phrase")) {
                    return SingletonIterator.makeIterator((Item)new StringValue((CharSequence)((String)((Map)eventInfo.getInfo()).get("response-reason-phrase"))));
                }
            } else if ("betterform-variable-changed".equals(eventInfo.getEventType())) {
                if ("varName".equals(event) && ((Map)eventInfo.getInfo()).containsKey("varName")) {
                    return SingletonIterator.makeIterator((Item)new StringValue((CharSequence)((String)((Map)eventInfo.getInfo()).get("varName"))));
                }
                if (XFormsConstants.VARIABLE_VALUE.equals(event) && ((Map)eventInfo.getInfo()).containsKey(XFormsConstants.VARIABLE_VALUE)) {
                    return SingletonIterator.makeIterator((Item)new StringValue((CharSequence)((String)((Map)eventInfo.getInfo()).get(XFormsConstants.VARIABLE_VALUE))));
                }
            } else if (eventInfo.getInfo() != null) {
                return SingletonIterator.makeIterator((Item)new StringValue((CharSequence)((String)((Map)eventInfo.getInfo()).get(event))));
            }
        }
        return EmptyIterator.getInstance();
    }

    public Item evaluateItem(XPathContext xpathContext) throws XPathException {
        CharSequence argAsString = this.argument[0].evaluateAsString(xpathContext);
        XPathFunctionContext functionContext = this.getFunctionContext(xpathContext);
        XFormsElement xformsElement = functionContext.getXFormsElement();
        Container.EventInfo infoObject = xformsElement.getContainerObject().getCurrentEventInfo();
        throw new RuntimeException("blurp");
    }
}

