/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function;

import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Instance;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import de.betterform.xml.xforms.xpath.saxon.function.XPathFunctionContext;
import java.util.Collections;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;

public class InstanceOfModel
extends XFormsFunction {
    private static final long serialVersionUID = -5302742873313974258L;

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public SequenceIterator iterate(XPathContext xpathContext) throws XPathException {
        if (this.argument.length != 2) {
            throw new XPathException("There must be 2 arguments (modelId, instanceId) for this function");
        }
        Expression modelIDExpression = this.argument[0];
        String modelId = modelIDExpression.evaluateAsString(xpathContext).toString();
        Expression instanceIdExpression = this.argument[1];
        String instanceId = instanceIdExpression.evaluateAsString(xpathContext).toString();
        return this.instanceOfModel(xpathContext, modelId, instanceId);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String modelId = arguments[0].head().getStringValue();
        String instanceId = arguments[0].head().getStringValue();
        return SequenceTool.toLazySequence((SequenceIterator)this.instanceOfModel(context, modelId, instanceId));
    }

    private SequenceIterator instanceOfModel(XPathContext context, String modelId, String instanceId) throws XPathException {
        XPathFunctionContext functionContext = this.getFunctionContext(context);
        if (functionContext != null) {
            Model model;
            XFormsElement element = functionContext.getXFormsElement();
            try {
                model = element.getContainerObject().getModel(modelId);
            }
            catch (XFormsException e) {
                throw new XPathException("Model: " + modelId + " not found");
            }
            Instance instance = model.getInstance(instanceId);
            if (instance != null) {
                return new ListIterator(instance.getInstanceNodeset());
            }
        }
        return new ListIterator(Collections.EMPTY_LIST);
    }
}

