/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function;

import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;

public class IsCardNumber
extends XFormsFunction {
    private static final long serialVersionUID = 1752327624237248755L;

    public Item evaluateItem(XPathContext xpathContext) throws XPathException {
        String luhnnumber = this.argument[0].evaluateAsString(xpathContext).toString();
        return this.isCardNumber(luhnnumber);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return this.isCardNumber(arguments[0].head().getStringValue());
    }

    private BooleanValue isCardNumber(String luhnnumber) {
        try {
            int result = 0;
            boolean alternation = false;
            for (int i = luhnnumber.length() - 1; i >= 0; --i) {
                int n = Integer.parseInt(luhnnumber.substring(i, i + 1));
                if (alternation && (n *= 2) > 9) {
                    n = n % 10 + 1;
                }
                result += n;
                alternation = !alternation;
            }
            return BooleanValue.get((result % 10 == 0 ? 1 : 0) != 0);
        }
        catch (NumberFormatException e) {
            return BooleanValue.FALSE;
        }
    }
}

