/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function;

import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.exception.XFormsComputeException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import de.betterform.xml.xforms.xpath.saxon.function.XPathFunctionContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class Property
extends XFormsFunction {
    private static final long serialVersionUID = -3790096351696399703L;
    private static final StringValue VERSION = new StringValue((CharSequence)"1.1");
    private static final StringValue CONFORMANCE = new StringValue((CharSequence)"full");

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public Item evaluateItem(XPathContext xpathContext) throws XPathException {
        String name = this.argument[0].evaluateAsString(xpathContext).toString();
        return this.getProperty(xpathContext, name);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String name = arguments[0].head().getStringValue();
        return this.getProperty(context, name);
    }

    private StringValue getProperty(XPathContext context, String name) throws XPathException {
        if ("version".equals(name)) {
            return VERSION;
        }
        if ("conformance-level".equals(name)) {
            return CONFORMANCE;
        }
        XPathFunctionContext functionContext = this.getFunctionContext(context);
        XFormsElement xformsElement = functionContext.getXFormsElement();
        if (xformsElement != null) {
            try {
                xformsElement.getContainerObject().dispatch(xformsElement.getId(), "xforms-binding-exception");
            }
            catch (XFormsException e) {
                throw new XPathException((Throwable)new XFormsComputeException("Requesting invalid property '" + name + "'", xformsElement.getTarget(), (Object)this));
            }
        } else {
            throw new XPathException((Throwable)new XFormsComputeException("Requesting invalid property '" + name + "'", xformsElement.getTarget(), (Object)this));
        }
        return new StringValue((CharSequence)"");
    }
}

