/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function;

import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DoubleValue;

public class SecondsFromDateTime
extends XFormsFunction {
    private static final long serialVersionUID = -166224567432883455L;

    public Item evaluateItem(XPathContext xpathContext) throws XPathException {
        CharSequence dateTime = this.argument[0].evaluateAsString(xpathContext);
        return this.secondsFromDateTime(dateTime.toString());
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String dateTime = arguments[0].head().getStringValue();
        return this.secondsFromDateTime(dateTime);
    }

    final DoubleValue secondsFromDateTime(String dateTime) {
        try {
            DateTimeValue argAsDateTime = (DateTimeValue)DateTimeValue.makeDateTimeValue((CharSequence)dateTime, (ConversionRules)new ConversionRules()).asAtomic();
            return new DoubleValue((double)argAsDateTime.getCalendar().getTimeInMillis() / 1000.0);
        }
        catch (XPathException e1) {
            return DoubleValue.NaN;
        }
    }
}

