/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function.xpath;

import de.betterform.xml.xforms.Container;
import de.betterform.xml.xforms.model.submission.RequestHeader;
import de.betterform.xml.xforms.model.submission.RequestHeaders;
import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.sf.saxon.dom.DOMNodeWrapper;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AppContext
extends XFormsFunction {
    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public SequenceIterator iterate(XPathContext xpathContext) throws XPathException {
        String defaultObject;
        if (this.argument.length < 1 || this.argument.length > 2) {
            throw new XPathException("There must be 1 argument (key)  or 2 arguments (key, defaultObject) for this function");
        }
        Expression keyExpression = this.argument[0];
        String key = keyExpression.evaluateAsString(xpathContext).toString();
        if (this.argument.length == 2) {
            Expression defaultObjectExpression = this.argument[1];
            defaultObject = defaultObjectExpression.evaluateAsString(xpathContext).toString();
        } else {
            defaultObject = null;
        }
        return this.appContext(xpathContext, key, defaultObject);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String key = arguments[0].head().getStringValue();
        String defaultObject = arguments.length == 2 ? arguments[1].head().getStringValue() : null;
        return SequenceTool.toLazySequence((SequenceIterator)this.appContext(context, key, defaultObject));
    }

    private SequenceIterator appContext(XPathContext xpathContext, String key, String defaultObject) {
        Container container = this.getContainer(xpathContext);
        Map appContext = container.getProcessor().getContext();
        String[] keys = key.split("/");
        for (int i = 0; i < keys.length - 1; ++i) {
            if (!appContext.containsKey(keys[i])) continue;
            Object o = appContext.get(keys[i]);
            if (keys[i].equals("http-headers")) {
                RequestHeader rh;
                if ((rh = ((RequestHeaders)o).getRequestHeader(keys[++i])) == null) continue;
                ArrayList<DOMNodeWrapper> list = new ArrayList<DOMNodeWrapper>();
                list.add(this.wrap(xpathContext, rh.getValue()));
                return new ListIterator(list);
            }
            if (o instanceof Map) {
                appContext = (Map)o;
                continue;
            }
            if (defaultObject != null) {
                ArrayList<DOMNodeWrapper> list = new ArrayList<DOMNodeWrapper>();
                list.add(this.wrap(xpathContext, defaultObject));
                return new ListIterator(list);
            }
            return new ListIterator(Collections.EMPTY_LIST);
        }
        if (appContext.containsKey(keys[keys.length - 1])) {
            ArrayList<DOMNodeWrapper> list = new ArrayList<DOMNodeWrapper>();
            list.add(this.wrap(xpathContext, appContext.get(keys[keys.length - 1])));
            return new ListIterator(list);
        }
        if (defaultObject != null) {
            ArrayList<DOMNodeWrapper> list = new ArrayList<DOMNodeWrapper>();
            list.add(this.wrap(xpathContext, defaultObject));
            return new ListIterator(list);
        }
        return new ListIterator(Collections.EMPTY_LIST);
    }

    private DOMNodeWrapper wrap(XPathContext xpathContext, Object o) {
        if (o instanceof Node) {
            return this.getDocumentElementContext((Document)o);
        }
        Document ownerDocument = ((Node)((DOMNodeWrapper)xpathContext.getCurrentIterator().current()).getUnderlyingNode()).getOwnerDocument();
        DocumentWrapper documentWrapper = this.getDocumentElementContext(ownerDocument);
        return documentWrapper.wrap((Node)ownerDocument.createTextNode(o.toString()));
    }

    private DocumentWrapper getDocumentElementContext(Document document) {
        return new DocumentWrapper((Node)document, "configuration.xml", new IndependentContext().getConfiguration());
    }
}

