/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function.xpath;

import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.util.SubnetUtils;

public class IsInIPRange
extends XFormsFunction {
    private static final Log LOGGER = LogFactory.getLog(IsInIPRange.class);

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public Item evaluateItem(XPathContext xpathContext) throws XPathException {
        if (this.argument.length != 3) {
            throw new XPathException("There must be 3 arguments (subnetid, subnetmask, ipaddress) for this function");
        }
        Expression subnetIDExpression = this.argument[0];
        String subnetID = subnetIDExpression.evaluateAsString(xpathContext).toString();
        Expression subnetMaskExpression = this.argument[1];
        String subnetMask = subnetMaskExpression.evaluateAsString(xpathContext).toString();
        Expression ipAddressExpression = this.argument[2];
        String ipAddress = ipAddressExpression.evaluateAsString(xpathContext).toString();
        return this.isInIPRange(subnetID, subnetMask, ipAddress);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String subnetID = arguments[0].head().getStringValue();
        String subnetMask = arguments[1].head().getStringValue();
        String ipAddress = arguments[2].head().getStringValue();
        return this.isInIPRange(subnetID, subnetMask, ipAddress);
    }

    private BooleanValue isInIPRange(String subnetID, String subnetMask, String ipAddress) {
        if ("".equals(subnetID.trim()) || "".equals(subnetMask.trim()) || "".equals(ipAddress.trim())) {
            return BooleanValue.FALSE;
        }
        SubnetUtils subnetUtils = new SubnetUtils(subnetID, subnetMask);
        try {
            if (subnetUtils.getInfo().isInRange(ipAddress)) {
                return BooleanValue.TRUE;
            }
        }
        catch (IllegalArgumentException iae) {
            LOGGER.debug((Object)"IsInIPRange Exception:", (Throwable)iae);
        }
        return BooleanValue.FALSE;
    }
}

