/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function.xpath;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.DescendingComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class Minimax2
extends CollatingFunction {
    public static final int MIN = 2;
    public static final int MAX = 3;
    private BuiltInAtomicType argumentType = BuiltInAtomicType.ANY_ATOMIC;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        this.argument[0] = ExpressionTool.unsortedIfHomogeneous((Expression)this.argument[0], (boolean)false);
    }

    public int computeCardinality() {
        int c = super.computeCardinality();
        if (!Cardinality.allowsZero((int)this.argument[0].getCardinality())) {
            c = 16384;
        }
        return c;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        return this;
    }

    public ItemType getItemType() {
        ItemType t = this.argument[0].getItemType();
        if (t.getPrimitiveType() == 631) {
            return BuiltInAtomicType.DOUBLE;
        }
        return t;
    }

    protected int getCollationArgument() {
        return 1;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        SequenceIterator iter = this.argument[0].iterate(context);
        return this.minimax(context, iter);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        SequenceIterator iter = arguments[0].iterate();
        return this.minimax(context, iter);
    }

    private AtomicValue minimax(XPathContext context, SequenceIterator values) throws XPathException {
        StringCollator collator = this.getCollator(context);
        BuiltInAtomicType type = this.argumentType;
        if (type == BuiltInAtomicType.UNTYPED_ATOMIC) {
            type = BuiltInAtomicType.DOUBLE;
        }
        AtomicComparer comparer = GenericAtomicComparer.makeAtomicComparer((BuiltInAtomicType)type, (BuiltInAtomicType)type, (StringCollator)collator, (XPathContext)context);
        try {
            return Minimax2.minimax(values, this.operation, comparer, false, context);
        }
        catch (XPathException err) {
            err.setLocator((SourceLocator)((Object)this));
            throw err;
        }
    }

    public static AtomicValue minimax(SequenceIterator iter, int operation, AtomicComparer atomicComparer, boolean ignoreNaN, XPathContext context) throws XPathException {
        AtomicValue test;
        AtomicValue prim;
        AtomicValue min;
        boolean foundNaN;
        boolean foundFloat;
        boolean foundDouble;
        block32: {
            block31: {
                TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
                foundDouble = false;
                foundFloat = false;
                foundNaN = false;
                if (operation == 3) {
                    atomicComparer = new DescendingComparer(atomicComparer);
                }
                do {
                    if ((min = (AtomicValue)iter.next()) == null) {
                        return DoubleValue.NaN;
                    }
                    prim = min;
                    if (min instanceof UntypedAtomicValue) {
                        try {
                            prim = min = DoubleValue.parseNumber((String)min.getStringValue());
                            foundDouble = true;
                        }
                        catch (NumberFormatException e) {
                            return DoubleValue.NaN;
                        }
                    } else if (prim instanceof DoubleValue) {
                        foundDouble = true;
                    } else if (prim instanceof FloatValue) {
                        foundFloat = true;
                    }
                    if (!(prim instanceof NumericValue) || !((NumericValue)prim).isNaN()) break block31;
                } while (ignoreNaN);
                if (prim instanceof DoubleValue) {
                    return min;
                }
                foundNaN = true;
                min = FloatValue.NaN;
                break block32;
            }
            if (!prim.getPrimitiveType().isOrdered(false)) {
                return DoubleValue.NaN;
            }
        }
        while ((test = (AtomicValue)iter.next()) != null) {
            AtomicValue test2;
            prim = test2 = test;
            if (test instanceof UntypedAtomicValue) {
                try {
                    test2 = DoubleValue.parseNumber((String)test.getStringValue());
                    if (foundNaN) {
                        return DoubleValue.NaN;
                    }
                    prim = test2;
                    foundDouble = true;
                }
                catch (NumberFormatException e) {
                    return DoubleValue.NaN;
                }
            } else if (prim instanceof DoubleValue) {
                if (foundNaN) {
                    return DoubleValue.NaN;
                }
                foundDouble = true;
            } else if (prim instanceof FloatValue) {
                foundFloat = true;
            }
            if (prim instanceof NumericValue && ((NumericValue)prim).isNaN()) {
                if (ignoreNaN) continue;
                if (foundDouble) {
                    return DoubleValue.NaN;
                }
                foundNaN = true;
                continue;
            }
            try {
                if (atomicComparer.compareAtomicValues(prim, min) >= 0) continue;
                min = test2;
            }
            catch (ClassCastException err) {
                return DoubleValue.NaN;
            }
        }
        if (foundNaN) {
            return FloatValue.NaN;
        }
        if (foundDouble) {
            if (!(min instanceof DoubleValue)) {
                min = DoubleValue.parseNumber((String)min.getStringValue());
            }
        } else if (foundFloat && !(min instanceof FloatValue)) {
            min = FloatValue.parseNumber((String)min.getStringValue());
        }
        return min;
    }
}

