/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function.xpath;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.Container;
import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSNamespaceItem;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SchemaChilds
extends XFormsFunction {
    private static final Log LOGGER = LogFactory.getLog(SchemaChilds.class);

    private XSTypeDefinition getTypeDefinition(XSModel schemaModel, String name, String namespace) {
        XSNamedMap map = schemaModel.getComponents((short)3);
        for (int j = 0; j < map.getLength(); ++j) {
            XSTypeDefinition xsTypeDefinition = (XSTypeDefinition)map.item(j);
            if (!xsTypeDefinition.getName().equals(name)) continue;
            if (namespace == null) {
                return xsTypeDefinition;
            }
            if (!xsTypeDefinition.getNamespace().equals(namespace)) continue;
            return xsTypeDefinition;
        }
        return null;
    }

    private Document getContextNode(String namespace, String elementName, XSModel xsModel) {
        try {
            ListIterator xsNamespaceItemList = xsModel.getNamespaceItems().listIterator();
            while (xsNamespaceItemList.hasNext()) {
                XSElementDeclaration xsElementDeclaration;
                String schemaNamespace = ((XSNamespaceItem)xsNamespaceItemList.next()).getSchemaNamespace();
                if (!namespace.equals(schemaNamespace) || (xsElementDeclaration = xsModel.getElementDeclaration(elementName, namespace)) == null) continue;
                return this.handleElement(xsElementDeclaration);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Document handleElement(XSElementDeclaration xsElementDeclaration) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        Document document = factory.newDocumentBuilder().newDocument();
        document.appendChild(document.createElementNS(xsElementDeclaration.getNamespace(), xsElementDeclaration.getName()));
        Element rootElement = document.getDocumentElement();
        XSTypeDefinition xsTypeDefinition = xsElementDeclaration.getTypeDefinition();
        if (xsTypeDefinition != null) {
            if (xsTypeDefinition instanceof XSComplexTypeDefinition) {
                this.handleComplexType((XSComplexTypeDefinition)xsTypeDefinition, document, rootElement);
            } else if (xsTypeDefinition instanceof XSComplexTypeDecl || xsTypeDefinition instanceof XSSimpleTypeDefinition) {
                // empty if block
            }
        }
        return document;
    }

    private void handleComplexType(XSComplexTypeDefinition xsComplexTypeDefinition, Document document, Element rootElement) {
        XSTerm term;
        if (xsComplexTypeDefinition.getParticle() != null && (term = xsComplexTypeDefinition.getParticle().getTerm()) instanceof XSModelGroup) {
            XSObjectList particles = ((XSModelGroup)term).getParticles();
            block5: for (int j = 0; j < particles.getLength(); ++j) {
                XSParticle particle = (XSParticle)particles.item(j);
                XSTerm particleTerm = particle.getTerm();
                if (particleTerm instanceof XSElementDeclaration) {
                    XSElementDeclaration xsElementDeclaration = (XSElementDeclaration)particleTerm;
                    Element childElement = document.createElementNS(xsElementDeclaration.getNamespace(), xsElementDeclaration.getName());
                    rootElement.appendChild(childElement);
                    continue;
                }
                if (!(particleTerm instanceof XSModelGroup)) continue;
                XSModelGroup group = (XSModelGroup)particleTerm;
                switch (group.getCompositor()) {
                    case 1: {
                        XSObjectList groupParticles = group.getParticles();
                        for (int z = 0; z < groupParticles.getLength(); ++z) {
                            XSParticle groupParticle = (XSParticle)groupParticles.item(z);
                            XSTerm groupParticleTerm = groupParticle.getTerm();
                            if (groupParticleTerm instanceof XSElementDeclaration) {
                                Element childElement = document.createElementNS(groupParticleTerm.getNamespace(), groupParticleTerm.getName());
                                rootElement.appendChild(childElement);
                                continue;
                            }
                            if (!(groupParticleTerm instanceof XSSimpleTypeDefinition) && !(groupParticleTerm instanceof XSComplexTypeDefinition) && !(groupParticleTerm instanceof XSModelGroup)) continue;
                        }
                        continue block5;
                    }
                    case 2: {
                        continue block5;
                    }
                    case 3: {
                        continue block5;
                    }
                    default: {
                        LOGGER.warn((Object)("SchemaReader: unknown Compositor in schema: " + ((XSModelGroup)term).getCompositor()));
                    }
                }
            }
        }
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public SequenceIterator iterate(XPathContext xpathContext) throws XPathException {
        String namespace = this.argument[0].evaluateAsString(xpathContext).toString();
        String elementName = this.argument[1].evaluateAsString(xpathContext).toString();
        return this.schemaChilds(xpathContext, namespace, elementName);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String namespace = arguments[0].head().getStringValue();
        String elementName = arguments[1].head().getStringValue();
        return SequenceTool.toLazySequence((SequenceIterator)this.schemaChilds(context, namespace, elementName));
    }

    private SequenceIterator schemaChilds(XPathContext context, String namespace, String elementName) throws XPathException {
        Container container = this.getContainer(context);
        if (container != null) {
            try {
                List schemas = container.getDefaultModel().getSchemas();
                for (XSModel xsModel : schemas) {
                    Document elementDocument = this.getContextNode(namespace, elementName, xsModel);
                    if (LOGGER.isDebugEnabled() && elementDocument != null) {
                        DOMUtil.prettyPrintDOM(elementDocument.getDocumentElement());
                    }
                    if (elementDocument == null) continue;
                    String baseURI = container.getProcessor().getBaseURI();
                    return new net.sf.saxon.tree.iter.ListIterator(XPathUtil.getRootContext(elementDocument, baseURI));
                }
            }
            catch (Exception e) {
                throw new XPathException((Throwable)e);
            }
        }
        return new net.sf.saxon.tree.iter.ListIterator(Collections.EMPTY_LIST);
    }
}

