/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xpath.impl.saxon;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.CompareToIntegerConstant;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IntegerRangeTest;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.SimpleStepExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.SubscriptExpression;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.flwor.TupleExpression;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.NumberInstruction;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.sort.ConditionalSorter;
import net.sf.saxon.expr.sort.SortExpression;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.tree.util.FastStringBuffer;

public class SaxonXPathExpressionSerializer {
    public static String serialize(Expression expr, Map prefixMapping) {
        FastStringBuffer result = new FastStringBuffer(64);
        HashMap reversePrefixMapping = new HashMap();
        for (Map.Entry entry : prefixMapping.entrySet()) {
            reversePrefixMapping.put(entry.getValue(), entry.getKey());
        }
        SaxonXPathExpressionSerializer.serialize(result, expr, reversePrefixMapping);
        return result.toString();
    }

    private static void serialize(FastStringBuffer result, Expression expr, Map reversePrefixMapping) {
        if (expr instanceof Assignation) {
            SaxonXPathExpressionSerializer.serialize(result, ((Assignation)expr).getAction(), reversePrefixMapping);
        } else if (expr instanceof AxisExpression && ((AxisExpression)expr).getAxis() == 9 && (!(((AxisExpression)expr).getNodeTest() instanceof NodeKindTest) || ((NodeKindTest)((AxisExpression)expr).getNodeTest()).getNodeKind() != 1)) {
            result.append("..");
        } else if (expr instanceof AxisExpression) {
            AxisExpression axisExpression = (AxisExpression)expr;
            result.append(AxisInfo.axisName[axisExpression.getAxis()]);
            result.append("::");
            NodeTest nodeTest = axisExpression.getNodeTest();
            if (nodeTest == null) {
                result.append("node()");
            } else if (nodeTest instanceof NameTest) {
                NameTest nt = (NameTest)nodeTest;
                NamePool namePool = nt.getNamePool();
                String localName = namePool.getLocalName(nt.getFingerprint());
                String prefix = namePool.getPrefix(nt.getFingerprint());
                String uri = namePool.getURI(nt.getFingerprint());
                localName = uri != null && !uri.trim().isEmpty() ? "{" + uri + "}" + localName : localName;
                localName = prefix != null && !prefix.trim().isEmpty() ? prefix + ":" + localName : localName;
                result.append(SaxonXPathExpressionSerializer.fixPreFixes(localName, reversePrefixMapping));
            } else {
                result.append(SaxonXPathExpressionSerializer.fixPreFixes(nodeTest.toString(), reversePrefixMapping));
            }
        } else if (expr instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expr;
            SaxonXPathExpressionSerializer.serialize(result, binaryExpression.getOperands()[0], reversePrefixMapping);
            result.append(" " + Token.tokens[binaryExpression.getOperator()] + " ");
            SaxonXPathExpressionSerializer.serialize(result, binaryExpression.getOperands()[1], reversePrefixMapping);
        } else if (expr instanceof CompareToIntegerConstant) {
            CompareToIntegerConstant compareToIntegerConstant = (CompareToIntegerConstant)expr;
            SaxonXPathExpressionSerializer.serialize(result, compareToIntegerConstant.getOperand(), reversePrefixMapping);
            result.append(" " + Token.tokens[compareToIntegerConstant.getComparisonOperator()] + " ");
            result.append(Long.toString(compareToIntegerConstant.getComparand()));
        } else if (!(expr instanceof ConditionalSorter)) {
            if (expr instanceof ContextItemExpression) {
                result.append('.');
            } else if (!(expr instanceof ErrorExpression)) {
                if (expr instanceof FilterExpression) {
                    FilterExpression filterExpression = (FilterExpression)expr;
                    SaxonXPathExpressionSerializer.serialize(result, filterExpression.getSelectExpression(), reversePrefixMapping);
                    result.append('[');
                    SaxonXPathExpressionSerializer.serialize(result, filterExpression.getFilter(), reversePrefixMapping);
                    result.append("]");
                } else if (expr instanceof FunctionCall) {
                    FunctionCall functionCall = (FunctionCall)expr;
                    StructuredQName name = functionCall.getFunctionName();
                    if (!(name.getPrefix() == null || name.getPrefix().length() <= 0 || name.getPrefix().equals("saxon") && name.getLocalPart().equals("item-at"))) {
                        result.append(name.getPrefix());
                        result.append(":");
                    }
                    if (name.getPrefix().equals("saxon") && name.getLocalPart().equals("item-at")) {
                        result.append("subsequence");
                    } else {
                        result.append(name.getLocalPart());
                    }
                    result.append("(");
                    boolean first = true;
                    for (Operand o : functionCall.operands()) {
                        result.append(first ? "" : ", ");
                        SaxonXPathExpressionSerializer.serialize(result, o.getExpression(), reversePrefixMapping);
                        first = false;
                    }
                    if (name.getPrefix().equals("saxon") && name.getLocalPart().equals("item-at")) {
                        result.append(",1");
                    }
                    result.append(")");
                } else if (expr instanceof SubscriptExpression) {
                    SaxonXPathExpressionSerializer.serialize(result, ((SubscriptExpression)expr).getBaseExpression(), reversePrefixMapping);
                    result.append("[");
                    SaxonXPathExpressionSerializer.serialize(result, ((SubscriptExpression)expr).getSubscriptExpression(), reversePrefixMapping);
                    result.append("]");
                } else if (!(expr instanceof Instruction) && !(expr instanceof IntegerRangeTest)) {
                    if (expr instanceof IsLastExpression) {
                        result.append("position() eq last()");
                    } else if (expr instanceof Literal) {
                        Literal literal = (Literal)expr;
                        result.append(literal.getValue().toString());
                    } else if (!(expr instanceof NumberInstruction)) {
                        if (expr instanceof SimpleStepExpression && ((SimpleStepExpression)expr).getSelectExpression() instanceof ItemChecker && ((ItemChecker)((SimpleStepExpression)expr).getSelectExpression()).getBaseExpression() instanceof ContextItemExpression) {
                            SimpleStepExpression simpleStepExpression = (SimpleStepExpression)expr;
                            Expression rhsExpression = simpleStepExpression.getActionExpression();
                            SaxonXPathExpressionSerializer.serialize(result, rhsExpression, reversePrefixMapping);
                        } else if (expr instanceof SlashExpression) {
                            SlashExpression slashExpression = (SlashExpression)expr;
                            SaxonXPathExpressionSerializer.serialize(result, slashExpression.getSelectExpression(), reversePrefixMapping);
                            result.append('/');
                            SaxonXPathExpressionSerializer.serialize(result, slashExpression.getActionExpression(), reversePrefixMapping);
                        } else if (!(expr instanceof PatternSponsor || expr instanceof SimpleExpression || expr instanceof RootExpression || expr instanceof SortExpression || expr instanceof TailExpression || expr instanceof TupleExpression)) {
                            VariableReference variableReference;
                            Binding binding;
                            if (expr instanceof UnaryExpression) {
                                UnaryExpression unaryExpression = (UnaryExpression)expr;
                                SaxonXPathExpressionSerializer.serialize(result, unaryExpression.getBaseExpression(), reversePrefixMapping);
                            } else if (expr instanceof VariableReference && (binding = (variableReference = (VariableReference)expr).getBinding()) instanceof LetExpression) {
                                LetExpression let = (LetExpression)binding;
                                SaxonXPathExpressionSerializer.serialize(result, let.getSequence(), reversePrefixMapping);
                            }
                        }
                    }
                }
            }
        }
    }

    private static String fixPreFixes(String xpath, Map<String, String> reversePrefixMapping) {
        FastStringBuffer result = new FastStringBuffer(xpath.length());
        Matcher m = Pattern.compile("\\{[^\\}]+\\}").matcher(xpath);
        int iLast = 0;
        while (m.find()) {
            result.append(xpath.substring(iLast, m.start()));
            String match = m.group();
            result.append(reversePrefixMapping.get(match.substring(1, match.length() - 1)));
            result.append(':');
            iLast = m.end();
        }
        result.append(xpath.substring(iLast));
        return result.toString();
    }
}

