/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xslt.impl;

import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xslt.TransformerService;
import de.betterform.xml.xslt.impl.Resource;
import de.betterform.xml.xslt.impl.ResourceResolver;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachingTransformerService
implements TransformerService,
URIResolver {
    private static final Log LOGGER = LogFactory.getLog(CachingTransformerService.class);
    private HashMap resources = new HashMap();
    private HashMap<String, URI> name2URI = new HashMap();
    private ArrayList resolvers = new ArrayList();
    private TransformerFactory transformerFactory;
    private boolean nocache = false;

    public CachingTransformerService() {
    }

    public CachingTransformerService(ResourceResolver resolver) {
        this();
        this.addResourceResolver(resolver);
    }

    @Override
    public TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = new TransformerFactoryImpl();
            this.transformerFactory.setURIResolver(this);
            this.transformerFactory.setErrorListener(new XmlStylesheetTransformerErrorListener());
        }
        return this.transformerFactory;
    }

    @Override
    public void setTransformerFactory(TransformerFactory factory) throws TransformerException {
        throw new TransformerException("You cannot set the TransformerFactory for this implementation. This service uses Saxon as XSLT engine.");
    }

    @Override
    public Transformer getTransformer() throws TransformerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"get transformer: identity transformer");
        }
        return this.getTransformerFactory().newTransformer();
    }

    public Transformer getTransformerByName(String xsltFileName) throws TransformerException {
        URI uri = this.name2URI.get(xsltFileName);
        return this.getTransformer(uri);
    }

    @Override
    public Transformer getTransformer(URI uri) throws TransformerException {
        if (uri == null) {
            return this.getTransformer();
        }
        try {
            CacheEntry entry = (CacheEntry)this.resources.get(uri);
            if (this.nocache || entry == null || entry.isDirty()) {
                Resource resource;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("get transformer: cache " + (entry == null ? "miss" : "dirty") + " for " + uri));
                }
                if ((resource = this.load(uri)) == null) {
                    throw new IllegalArgumentException(uri.toString());
                }
                entry = this.sync(entry, resource);
                this.resources.put(uri, entry);
                this.name2URI.put(this.getXsltName(uri), uri);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("get transformer: cache hit for " + uri));
            }
            if (entry.templates == null) {
                StreamSource source = new StreamSource(entry.resource.getInputStream());
                source.setSystemId(uri.toString());
                entry.templates = this.getTransformerFactory().newTemplates(source);
            }
            return entry.templates.newTransformer();
        }
        catch (Exception e) {
            throw new TransformerException(e);
        }
    }

    private String getXsltName(URI uri) {
        String s = uri.toString();
        return s.substring(s.lastIndexOf("/") + 1);
    }

    public void setNoCache(boolean b) {
        this.nocache = b;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("resolve: " + href + " against " + base));
            }
            URI uri = base != null ? new URI(base).resolve(href) : new URI(href);
            CacheEntry entry = (CacheEntry)this.resources.get(uri);
            if (this.nocache || entry == null || entry.isDirty() || !entry.isTransform()) {
                Resource resource;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("resolve: cache " + (entry == null ? "miss" : "dirty") + " for " + uri));
                }
                if ((resource = this.load(uri)) == null) {
                    return null;
                }
                entry = this.sync(entry, resource);
                this.resources.put(uri, entry);
                if (base != null) {
                    CacheEntry parent = (CacheEntry)this.resources.get(new URI(base));
                    parent.dependencies.add(entry);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("resolve: cache hit for " + uri));
            }
            Source source = entry.resource.getSource();
            source.setSystemId(uri.toString());
            return source;
        }
        catch (Exception e) {
            throw new TransformerException(e);
        }
    }

    public void addResourceResolver(ResourceResolver resolver) {
        this.resolvers.add(resolver);
    }

    public void removeResourceResolver(ResourceResolver resolver) {
        this.resolvers.remove(resolver);
    }

    private Resource load(URI uri) throws XFormsException {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ResourceResolver resolver = (ResourceResolver)this.resolvers.get(i);
            Resource resource = resolver.resolve(uri);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    private CacheEntry sync(CacheEntry entry, Resource resource) {
        if (entry == null) {
            entry = new CacheEntry(resource.lastModified(), resource);
        } else {
            entry.lastModified = resource.lastModified();
            entry.resource = resource;
            entry.templates = null;
            entry.dependencies.clear();
        }
        return entry;
    }

    private static class XmlStylesheetTransformerErrorListener
    implements ErrorListener {
        private XmlStylesheetTransformerErrorListener() {
        }

        @Override
        public void error(TransformerException ex) throws TransformerException {
            ex.printStackTrace();
            throw ex;
        }

        @Override
        public void fatalError(TransformerException ex) throws TransformerException {
            ex.printStackTrace();
            throw ex;
        }

        @Override
        public void warning(TransformerException ex) throws TransformerException {
            ex.printStackTrace();
            throw ex;
        }
    }

    private static class CacheEntry {
        long lastModified;
        Resource resource;
        Templates templates;
        List dependencies;

        CacheEntry(long lastModified, Resource resource) {
            this.lastModified = lastModified;
            this.resource = resource;
            this.dependencies = new ArrayList();
        }

        boolean isDirty() {
            if (this.lastModified < this.resource.lastModified()) {
                return true;
            }
            for (int i = 0; i < this.dependencies.size(); ++i) {
                if (!((CacheEntry)this.dependencies.get(i)).isDirty()) continue;
                return true;
            }
            return false;
        }

        boolean isTransform() throws XFormsException {
            return this.resource.getSource().getSystemId() != null && this.resource.getSource().getSystemId().endsWith(".xsl");
        }
    }
}

