/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util.collection;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.cleartk.util.collection.StringMapper;
import org.cleartk.util.collection.UnknownKeyException;
import org.cleartk.util.collection.Writable;

public class GenericStringMapper
implements StringMapper,
Writable {
    private static final long serialVersionUID = -9129249759791539649L;
    boolean expandMap = true;
    int nextValue = 1;
    int cutoff;
    Map<String, Entry> countingMap = new HashMap<String, Entry>();
    Map<String, Integer> stringIntMap = null;

    public GenericStringMapper(int cutoff) {
        this.cutoff = cutoff;
    }

    @Override
    public int getOrGenerateInteger(String s) {
        if (this.expandMap) {
            if (this.countingMap.containsKey(s)) {
                Entry e = this.countingMap.get(s);
                e.increment();
                return e.i;
            }
            Entry e = new Entry(this.nextValue++);
            this.countingMap.put(s, e);
            return e.i;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInteger(String s) throws UnknownKeyException {
        if (this.expandMap) {
            throw new UnsupportedOperationException();
        }
        if (this.stringIntMap.containsKey(s)) {
            return this.stringIntMap.get(s);
        }
        throw new UnknownKeyException(s);
    }

    @Override
    public void finalizeMap() {
        int total = 0;
        int kept = 0;
        this.stringIntMap = new HashMap<String, Integer>();
        for (String s : this.countingMap.keySet()) {
            Entry e = this.countingMap.get(s);
            ++total;
            if (e.count < this.cutoff) continue;
            this.stringIntMap.put(s, e.i);
            ++kept;
        }
        if (total - kept > 0) {
            Logger.getLogger(this.getClass().getName()).info(String.format("discarded %d features that occurred less than %d times; %d features remaining", total - kept, this.cutoff, kept));
        }
        this.countingMap = null;
        this.expandMap = false;
    }

    @Override
    public void write(File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        this.write(writer);
        ((Writer)writer).close();
    }

    @Override
    public void write(Writer writer) throws IOException {
        if (this.expandMap) {
            throw new UnsupportedOperationException();
        }
        for (String key : this.stringIntMap.keySet()) {
            writer.append(String.format("%d %s\n", this.stringIntMap.get(key), key));
        }
        writer.flush();
    }

    private static class Entry {
        public int i;
        public int count;

        public Entry(int i) {
            this.i = i;
            this.count = 1;
        }

        public void increment() {
            ++this.count;
        }
    }
}

